/******************************************************************************/
//    File Name     : Tyson.java
//                            Java Applet source file
//    Name          : Yoshiyuki Tanaka
//                    (e-Mail : tanaka_y@jaist.ac.jp)
//    Class Name    :     1.Tyson()
/******************************************************************************/

/******************************************************************************/
//                                  IMPORT
/******************************************************************************/
import java.awt.*;

/******************************************************************************/
//    Class Name    : Tyson
/******************************************************************************/
public class Tyson{

    /***** VALUE DATA *****/
    public    static TysonParam param = new TysonParam();
    protected        int        v     = 0;
    protected        byte       u     = 0;
    protected        byte       ut    = 0;

    /***** CONSTRUCTOR *****/
    Tyson(int _v, byte _n, byte _o){ this.v = _v; this.u = _n; this.ut =_o; }

    Tyson(int _v, byte _n){ this(_v,       _n, (byte)0) ;}
    Tyson(int _v)         { this(_v,  (byte)0, (byte)0) ;}
    Tyson()               { this( 0,  (byte)0, (byte)0) ;}


    /** INSTANCE METHOD **/
    /**************************************************************************/
    //    Method Name   : reset()
    /**************************************************************************/
    protected void  reset() { this.v = 0; this.u = 0; this.ut= 0; }

    /**************************************************************************/
    //    Method Name   : setCell()
    /**************************************************************************/
    protected void setCell(int _v, byte _s)
    { this.v  = _v ; this.u  = _s ; this.ut = _s ; }

    /**************************************************************************/
    //    Method Name   : renewalState()
    /**************************************************************************/
    protected void renewalState() { this.u = this.ut; }

    /**************************************************************************/
    //    Method Name   : checkExc()
    /**************************************************************************/
    public boolean check(){
        if(this.u == 0){
            if( this.v < param.getVexci() ) return true;
            else{ this.vmax();          return false; }
        }else{
            if( this.v > param.getVreco() ){
                if( v == param.getMax() ){ this.ut = 0; return false; }
                else                                return true;
            }else{
                this.vmin(); return false;
            }
        }
    }

    public void check(int _exc){
        int E = (2 * param.getr() + 1)*(2 * param.getr() + 1);

        if(this.u == 0){
            E = _exc;
            if( E > kexci() ) this.ut = 1;
            else              this.vmax();
        }else{
            E = E - _exc;
            if( E > kreco() ) this.ut = 0;
            else              this.vmin();
        }
    }

    public boolean checkExc() { return (this.u != 0); }


    /**************************************************************************/
    //    Method Name   : vmax()
    //    Method Name   : vmin()
    /**************************************************************************/
    public void vmax(){
        this.v = this.v - param.getGdown();
        if(this.v < 0) this.v = 0;
        this.ut = 0;
    }

    public void vmin(){
        int max = param.getMax();

        this.v  = this.v + param.getGup();
        if(this.v > max) this.v = max;
        this.ut = 1;
    }

    /**************************************************************************/
    //    Method Name   : kexci()
    //    Method Name   : kreco()
    /**************************************************************************/
    public int kexci(){
        int r  = param.getr(), ke = param.getk0exci();

        r = r * (1 + 2 * r);
        return ( (int)( ( ( (r - ke)*this.v )/param.getVexci() ) ) + ke );
    }

    public int kreco(){
        int r   = param.getr();
        int kr  = param.getk0reco();
        int max = param.getMax();

        r = r * (1 + 2 * r);
        return ( (int)( ( (r - kr)*(this.v - max) )/(kr - max) ) + kr );
    }

    /**************************************************************************/
    //    Method Name   : getColor()
    /**************************************************************************/
    public Color getColor(){
        int level = 255;
        int max   = param.getMax();

        if(this.u == 0){
             level = (int)( (this.v * 255) / max );
             if(level < 150) level = 0;
             return new Color( 0, 0, level );
        }else{
             level = (int)( (this.v * 255) / (2 * max) );
             level = 255 - level;
           return new Color( level, 0, 0 );

        }
    }
}


/**** END_of_file: Tyson.java **************************************************/
