/******************************************************************************/
//    File Name     : Tysons.java
//                            Java Applet source file
//    Name          : Yoshiyuki Tanaka
//                    (e-Mail : tanaka_y@jaist.ac.jp)
/******************************************************************************/

/******************************************************************************/
//                                  IMPORT
/******************************************************************************/
import java.awt.*;

/******************************************************************************/
//    Class Name    : Tysons
/******************************************************************************/
public class Tysons
{
    /***** VALUE DATA *****/
    protected static Dimension  dim   = new Dimension(200, 200);
    protected static int        time  = 0;

    public    static Tyson[][]  cell  = new Tyson[dim.height][dim.width];
    public    static TysonParam param = new TysonParam();

    /***** CONSTRUCTOR *****/
    public Tysons(){
        for(int i = 0; i < cell.length; i++)
            for(int j = 0; j < cell[i].length; cell[i][j++] = new Tyson());
    }

    /** INSTANCE METHOD **/
    /**************************************************************************/
    //    Method Name   : reset()
    /**************************************************************************/
    public void reset()
    {
        for(int i = 0; i < cell.length; i++)
            for(int j = 0; j < cell[i].length; cell[i][j++].reset() );
        time = 0;
    }


    /**************************************************************************/
    //    Method Name   : grow()
    /**************************************************************************/
    public void grow()
    {
        for(int i = 0; i < cell.length; i++){
            for(int j = 0; j < cell[i].length; j++){
                if( cell[i][j].check() ){
                    int r   = param.getr();
                    int exc = 0;

                    for(int m = -r; m <= r; m++ ){
                        if( (i + m < 0)||(i + m >= cell.length) )continue;

                        for(int n = -r; n <= r; n++ ){
                            if( (j + n < 0)||(j + n >= cell.length) )continue;
                            if( cell[i + m][j + n].checkExc() ) exc++;
                        }
                    }
                    cell[i][j].check(exc);
                }
            }
        }
        for(int i = 0; i < cell.length; i++)
            for(int j = 0; j < cell[i].length; cell[i][j++].renewalState() );
        this.time++;

    }

    /**************************************************************************/
    //    Method Name   : getdim()
    //    Method Name   : gettime()
    /**************************************************************************/
    public Dimension getdim() { return dim ;}
    public int       gettime(){ return time ;}

}


/**** END_of_file: Tysons.java *************************************************/
