/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Random;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class Cell {
    int m_initialiPosition = 0;
    double m_density = 0.1;
    JTextField m_txDensity = new JTextField("" + this.m_density);
    JTextField m_txInitialiPosition = new JTextField("" + this.m_initialiPosition);
    MainPanel m_mainPanel = null;
    JLabel m_statusLabel = null;
    Unit[][][] m_cellular;
    int m_cellularXMax = 0;
    int m_cellularYMax = 0;
    int m_cellularZMax = 0;

    void setDisplayElements(Container container, Container container2) {
        container2.add(new JLabel(" density"));
        container2.add(this.m_txDensity);
        container2.add(new JLabel(" init pos"));
        container2.add(this.m_txInitialiPosition);
    }

    void applyDisplayElements() {
        double d = this.m_density;
        try {
            this.m_density = Double.parseDouble(this.m_txDensity.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("density " + numberFormatException);
        }
        try {
            this.m_initialiPosition = Integer.parseInt(this.m_txInitialiPosition.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("init pos " + numberFormatException);
        }
        if (d != this.m_density) {
            this.initializeCellsStatus();
        }
    }

    double addDensity(double d) {
        double d2 = this.m_density;
        this.m_density = this.addDouble(this.m_density, d, 1.0);
        this.m_txDensity.setText("" + this.m_density);
        this.initializeCellsStatus();
        return d2;
    }

    double addDouble(double d, double d2) {
        d += d2;
        int n = (int)((d *= 1.0E7) + 0.5);
        return (double)n / 1.0E7;
    }

    double addDouble(double d, double d2, double d3) {
        if (d + d2 > d3) {
            d -= d3;
        }
        return this.addDouble(d, d2);
    }

    double addDouble(double d, double d2, double d3, double d4) {
        if (d + d2 > d3) {
            d = d4;
            return this.addDouble(d, 0.0);
        }
        return this.addDouble(d, d2);
    }

    void setMainPanel(MainPanel mainPanel, JLabel jLabel) {
        this.m_mainPanel = mainPanel;
        this.m_statusLabel = jLabel;
    }

    void stopExecute() {
        if (this.m_mainPanel != null) {
            this.m_mainPanel.stopThread();
        }
    }

    void initializeCellsStatus() {
        Object object;
        int n;
        int n2;
        int n3 = 0;
        while (n3 < this.m_cellularZMax) {
            int n4 = 0;
            while (n4 < this.m_cellularYMax) {
                n2 = 0;
                while (n2 < this.m_cellularXMax) {
                    this.m_cellular[n3][n4][n2].setDefaultState();
                    ++n2;
                }
                ++n4;
            }
            ++n3;
        }
        Vector<Integer> vector = new Vector<Integer>();
        n2 = this.m_cellularYMax - 1;
        int n5 = 0;
        while (n5 < this.m_cellularZMax) {
            n = 0;
            while (n < this.m_cellularXMax) {
                vector.add(new Integer(n5 * this.m_cellularXMax + n));
                ++n;
            }
            ++n5;
        }
        n = this.m_cellularZMax * this.m_cellularXMax;
        int n6 = (int)((double)n * this.m_density);
        int n7 = n / n6;
        int n8 = n - n6 * n7;
        int n9 = 0;
        Random random = new Random();
        int n10 = 0;
        while (n10 < (int)((double)n * this.m_density)) {
            switch (this.m_initialiPosition) {
                case 0: {
                    object = (Integer)vector.remove((int)(random.nextDouble() * (double)vector.size()));
                    break;
                }
                case 1: {
                    int n11 = 10;
                    if (vector.size() <= n11) {
                        object = (Integer)vector.remove(vector.size() - 1);
                        break;
                    }
                    object = (Integer)vector.remove(n11);
                    break;
                }
                case 2: {
                    if (n10 < n8) {
                        object = (Integer)vector.remove(n9 += n7);
                        break;
                    }
                    object = (Integer)vector.remove(n9 += n7 - 1);
                    break;
                }
                default: {
                    System.out.println("m_initialiPosition error - " + this.m_initialiPosition);
                    return;
                }
            }
            this.m_cellular[(Integer)object / n][n2][(Integer)object % n].setInitialState(true);
            ++n10;
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            Integer n12 = (Integer)object.nextElement();
            this.m_cellular[n12 / n][n2][n12 % n].setInitialState(false);
        }
    }

    void initializeCellsLocation(Dimension dimension) {
        int n = (int)(dimension.getWidth() / (double)this.m_cellularXMax);
        int n2 = (int)(dimension.getHeight() / (double)this.m_cellularYMax);
        int n3 = (int)((dimension.getWidth() - (double)(n * this.m_cellularXMax)) / 2.0);
        int n4 = (int)((dimension.getHeight() - (double)(n2 * this.m_cellularYMax)) / 2.0);
        int n5 = 0;
        while (n5 < this.m_cellularZMax) {
            int n6 = 0;
            while (n6 < this.m_cellularYMax) {
                int n7 = 0;
                while (n7 < this.m_cellularXMax) {
                    this.m_cellular[n5][n6][n7].setLocation(n3 + n7 * n, n4 + n6 * n2, n, n2);
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
    }

    void paintCells(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        int n = 0;
        while (n < this.m_cellularZMax) {
            int n2 = 0;
            while (n2 < this.m_cellularYMax) {
                int n3 = 0;
                while (n3 < this.m_cellularXMax) {
                    this.m_cellular[n][n2][n3].paint(graphics);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        graphics.setColor(color);
    }

    boolean createUnit(Integer n, Integer n2, Integer n3) {
        return false;
    }

    boolean executeCells() {
        return false;
    }

    public class Unit {
        int m_xOrder;
        int m_yOrder;
        int m_zOrder;
        int m_xPosition = 0;
        int m_yPosition = 0;
        int m_width = 0;
        int m_height = 0;
        boolean m_status = false;
        boolean m_statusNext = false;
        int m_nStatusTrueCount = 0;

        boolean recalc() {
            return false;
        }

        void setOrder(int n, int n2, int n3) {
            this.m_xOrder = n;
            this.m_yOrder = n2;
            this.m_zOrder = n3;
        }

        int getXOrder() {
            return this.m_xOrder;
        }

        int getYOrder() {
            return this.m_yOrder;
        }

        int getZOrder() {
            return this.m_zOrder;
        }

        void setLocation(int n, int n2, int n3, int n4) {
            this.m_xPosition = n;
            this.m_yPosition = n2;
            this.m_width = n3;
            this.m_height = n4;
        }

        Color getStatusTrueColor() {
            return Color.blue;
        }

        void paint(Graphics graphics) {
            graphics.drawRect(this.m_xPosition, this.m_yPosition, this.m_width, this.m_height);
            if (this.m_status) {
                Color color = graphics.getColor();
                graphics.setColor(this.getStatusTrueColor());
                graphics.fillRect(this.m_xPosition + 1, this.m_yPosition + 1, this.m_width - 1, this.m_height - 1);
                graphics.setColor(color);
            }
        }

        void setInitialState(boolean bl) {
            this.setDefaultState();
            if (bl) {
                this.setStatus(true);
            } else {
                this.setStatus(false);
            }
        }

        void setDefaultState() {
            this.setStatus(false);
        }

        void setStatus(boolean bl) {
            this.m_nStatusTrueCount = bl ? ++this.m_nStatusTrueCount : 0;
            this.m_status = bl;
        }

        void copyStatus(Unit unit) {
            this.m_status = unit.m_status;
            this.m_statusNext = unit.m_statusNext;
            this.m_nStatusTrueCount = unit.m_nStatusTrueCount;
        }

        boolean getStatus() {
            return this.m_status;
        }

        boolean getStatusNext() {
            return this.m_statusNext;
        }

        int getStatusTrueCount() {
            return this.m_nStatusTrueCount;
        }

        void setStatusNext(boolean bl) {
            this.m_statusNext = bl;
        }

        void update() {
            this.setStatus(this.m_statusNext);
        }
    }
}

