/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class CellSTCA
extends CellTraffic {
    int m_collectX = 1;
    double m_downSpeed = 0.0;
    JTextField m_txDownSpeed = new JTextField("" + this.m_downSpeed);

    void setDisplayElements(Container container, Container container2) {
        super.setDisplayElements(container, container2);
        container2.add(new JLabel(" Pvd"));
        container2.add(this.m_txDownSpeed);
    }

    void applyDisplayElements() {
        super.applyDisplayElements();
        try {
            this.m_downSpeed = Double.parseDouble(this.m_txDownSpeed.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    double addDownSpeed(double d) {
        double d2 = this.m_downSpeed;
        this.m_downSpeed = this.addDouble(this.m_downSpeed, d, 1.0, 0.0);
        this.m_txDownSpeed.setText("" + this.m_downSpeed);
        return d2;
    }

    Object createUnitInstance() {
        return new UnitSTCA();
    }

    CellSTCA() {
        if (Collect.isCollect()) {
            this.m_collect = new Collect();
            this.m_collect.initialize(this.getClass().getName() + ".csv");
        } else {
            this.m_collect = null;
        }
    }

    Object createCarInstance() {
        return new CarSTCA();
    }

    public class CarSTCA
    extends CellTraffic.Car {
        int m_countOfTimeEscapedFromJams = -1;
        int m_countOfTimeEscapedFromJamsCollect = -1;
        int m_lastVelocityEscapedFromJamsCollect = -1;
        int m_countStop = 0;
        int m_countStopCollect = 0;
        int m_collectFlag = 0;
        int m_collectFlagSpeed = 0;

        public CarSTCA() {
            super(CellSTCA.this);
        }

        void copy(CellTraffic.Car car) {
            super.copy(car);
            this.m_countStop = ((CarSTCA)car).m_countStop;
            this.m_countStopCollect = ((CarSTCA)car).m_countStopCollect;
            this.m_countOfTimeEscapedFromJams = ((CarSTCA)car).m_countOfTimeEscapedFromJams;
            this.m_countOfTimeEscapedFromJamsCollect = ((CarSTCA)car).m_countOfTimeEscapedFromJamsCollect;
            this.m_lastVelocityEscapedFromJamsCollect = ((CarSTCA)car).m_lastVelocityEscapedFromJamsCollect;
        }

        void setInitialParam() {
            super.setInitialParam();
            this.m_countStop = 0;
            this.m_countStopCollect = 0;
            this.m_countOfTimeEscapedFromJams = -1;
            this.m_countOfTimeEscapedFromJamsCollect = -1;
            this.m_lastVelocityEscapedFromJamsCollect = -1;
            this.m_velocityMax = 5;
            this.m_velocityMin = 0;
            this.m_velocity = 4;
            this.m_velocityNext = 4;
        }

        void setLocation(int n, int n2, int n3) {
            super.setLocation(n, n2, n3);
            if (n == CellSTCA.this.m_collectX) {
                this.m_collectFlagSpeed = this.m_velocityNext;
                this.m_collectFlag = 1;
            }
        }

        boolean recalc() {
            int n = 1;
            int n2 = this.m_x;
            while (n <= this.m_velocity) {
                n2 = this.m_x + n;
                if (n2 >= CellSTCA.this.m_cellularXMax) {
                    n2 -= CellSTCA.this.m_cellularXMax;
                }
                if (CellSTCA.this.m_cellular[this.m_z][this.m_y][n2].getStatus()) {
                    if (n2 == 0) {
                        n2 = CellSTCA.this.m_cellularXMax - 1;
                        break;
                    }
                    --n2;
                    break;
                }
                ++n;
            }
            this.m_progress = --n;
            if (n != this.m_velocity) {
                this.m_velocityNext = n < this.m_velocityMin ? this.m_velocityMin : n;
                if (this.m_countOfTimeEscapedFromJams != -1) {
                    this.m_countOfTimeEscapedFromJamsCollect = this.m_countOfTimeEscapedFromJams;
                    this.m_lastVelocityEscapedFromJamsCollect = n;
                    this.m_countOfTimeEscapedFromJams = -1;
                }
            } else {
                if (this.m_velocity != this.m_velocityMax) {
                    this.m_velocityNext = this.m_velocity + 1;
                }
                if (this.m_countOfTimeEscapedFromJams != -1) {
                    ++this.m_countOfTimeEscapedFromJams;
                    if (this.m_velocity == this.m_velocityMax) {
                        this.m_countOfTimeEscapedFromJamsCollect = this.m_countOfTimeEscapedFromJams;
                        this.m_lastVelocityEscapedFromJamsCollect = n;
                        this.m_countOfTimeEscapedFromJams = -1;
                    }
                }
            }
            this.m_xNext = n2;
            if (this.m_x != this.m_xNext) {
                ((CellTraffic.UnitTraffic)CellSTCA.this.m_cellular[this.m_z][this.m_y][this.m_x]).removeCar();
                ((CellTraffic.UnitTraffic)CellSTCA.this.m_cellular[this.m_z][this.m_y][this.m_xNext]).setCar(this);
                if (this.m_countStop != 0) {
                    this.m_countStopCollect = this.m_countStop;
                    this.m_countStop = 0;
                    this.m_countOfTimeEscapedFromJams = 1;
                }
            } else {
                ++this.m_countStop;
            }
            if (Math.random() <= CellSTCA.this.m_downSpeed && this.m_velocityNext > this.m_velocityMin) {
                --this.m_velocityNext;
            }
            if (CellSTCA.this.m_collect != null) {
                this.collectData();
            }
            return true;
        }

        void collectData() {
            if (this.m_countStopCollect != 0) {
                CellSTCA.this.m_collect.setDataCountStop(this.m_countStopCollect);
                this.m_countStopCollect = 0;
            }
            if (this.m_countOfTimeEscapedFromJamsCollect != -1) {
                CellSTCA.this.m_collect.setDataCountOfTimeAndVelocityEscapedFromJams(this.m_countOfTimeEscapedFromJamsCollect, this.m_lastVelocityEscapedFromJamsCollect);
                this.m_countOfTimeEscapedFromJamsCollect = -1;
                this.m_lastVelocityEscapedFromJamsCollect = -1;
            }
            int n = this.m_x <= this.m_xNext ? this.m_x : this.m_x - CellSTCA.this.m_cellularXMax;
            int n2 = this.m_xNext - n;
            CellSTCA.this.m_collect.setDataAllPosition(n2);
            if (n <= CellSTCA.this.m_collectX && CellSTCA.this.m_collectX <= this.m_xNext) {
                if (this.m_xNext == CellSTCA.this.m_collectX) {
                    if (this.m_collectFlag == 0) {
                        this.m_collectFlagSpeed = n2;
                    }
                    ++this.m_collectFlag;
                } else {
                    if (this.m_collectFlag > 0) {
                        CellSTCA.this.m_collect.setDataCheckPoint((double)(this.m_collectFlagSpeed + n2) / (double)(this.m_collectFlag + 1));
                    } else {
                        CellSTCA.this.m_collect.setDataCheckPoint(n2);
                    }
                    this.m_collectFlag = 0;
                    this.m_collectFlagSpeed = 0;
                }
            }
        }
    }

    public class UnitSTCA
    extends CellTraffic.UnitTraffic {
        public UnitSTCA() {
            super(CellSTCA.this);
        }
    }
}

