/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MainPanel
extends JPanel
implements Runnable {
    int m_nSleepTime;
    Thread m_threadme = null;
    int m_executeOfRepaint = 1;
    boolean m_cellularInitializeLocation = false;
    Cell m_cellObject = null;
    JLabel m_statusLabel = new JLabel("status", 0);
    JTextField m_txSleepTime;
    JTextField m_txExecuteOfRepaint;

    MainPanel(int n) {
        this.m_nSleepTime = n;
        this.m_txSleepTime = new JTextField("" + this.m_nSleepTime);
        this.m_txExecuteOfRepaint = new JTextField("" + this.m_executeOfRepaint);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MainPanel.this.initializeLocation();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_statusLabel, "South");
    }

    boolean initialize(String string, int n, int n2, int n3) {
        try {
            Class<?> clazz = Class.forName(string);
            this.m_cellObject = (Cell)clazz.newInstance();
            this.m_cellObject.setMainPanel(this, this.m_statusLabel);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return false;
        }
        if (!this.m_cellObject.createUnit(new Integer(n), new Integer(n2), new Integer(n3))) {
            System.out.println("cellObject.createUnit function was failed!");
            return false;
        }
        this.m_cellObject.initializeCellsStatus();
        this.m_cellularInitializeLocation = false;
        return true;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.m_cellularInitializeLocation) {
            this.initializeLocation();
        }
        this.m_cellObject.paintCells(graphics);
    }

    boolean execute() {
        return this.m_cellObject.executeCells();
    }

    public void run() {
        Thread thread = Thread.currentThread();
        int n = 0;
        while (thread == this.m_threadme) {
            if (!this.execute()) {
                this.repaint();
                this.m_threadme = null;
                break;
            }
            if (++n % this.m_executeOfRepaint == 0) {
                this.repaint();
            }
            if (this.m_nSleepTime == 0) continue;
            try {
                Thread.sleep(this.m_nSleepTime);
            }
            catch (InterruptedException interruptedException) {
                System.out.println(interruptedException);
                break;
            }
        }
    }

    void setDisplayElements(Container container, Container container2) {
        container2.add(new JLabel(" sleep"));
        container2.add(this.m_txSleepTime);
        container2.add(new JLabel(" repaint"));
        container2.add(this.m_txExecuteOfRepaint);
        this.m_cellObject.setDisplayElements(container, container2);
    }

    void applyDisplayElements() {
        try {
            this.m_nSleepTime = Integer.parseInt(this.m_txSleepTime.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("sleep time " + numberFormatException);
        }
        try {
            this.m_executeOfRepaint = Integer.parseInt(this.m_txExecuteOfRepaint.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(" execution count of repaint " + numberFormatException);
        }
        this.m_cellObject.applyDisplayElements();
    }

    void initializeLocation() {
        this.m_cellularInitializeLocation = true;
        Dimension dimension = new Dimension(this.getSize().width, this.getSize().height - this.m_statusLabel.getSize().height);
        this.m_cellObject.initializeCellsLocation(dimension);
    }

    void initializeStatus() {
        this.m_cellObject.initializeCellsStatus();
    }

    void startThread() {
        if (this.m_threadme == null) {
            this.m_threadme = new Thread(this);
            this.m_threadme.start();
        }
    }

    void stopThread() {
        this.m_threadme = null;
    }
}

