// Copyright (C) 2001 by Nakada,Toyohisa. All Rights Reserved.
import java.awt.*;
import javax.swing.*;
import java.util.*;

/**
 * Cell̊{NXB̃NX̓Z̑ŜǗNXBX̃ŹA
 * Inner Class  class Unit Œ`ĂB
 * @author Nakada,Toyohisa
 */
public class Cell{
	/** TRUEZԂ̌vZ@ 0: random 1: 1Âu 2: Ԋu*/
	int m_initialiPosition = 0;
	double m_density = 0.1;

	JTextField m_txDensity = new JTextField(""+m_density);
	JTextField m_txInitialiPosition = new JTextField(""+m_initialiPosition);
	void setDisplayElements(Container control,Container left){
		left.add(new JLabel(" density"));
		left.add(m_txDensity);
		left.add(new JLabel(" init pos"));
		left.add(m_txInitialiPosition);
	}
	void applyDisplayElements(){
		double densityOld = m_density;
		try{
			m_density = Double.parseDouble(m_txDensity.getText().trim());
		}catch(NumberFormatException e){
			System.out.println("density "+e);
		}
		try{
			m_initialiPosition = Integer.parseInt(m_txInitialiPosition.getText().trim());
		}catch(NumberFormatException e){
			System.out.println("init pos "+e);
		}
		if(densityOld != m_density){
			initializeCellsStatus();
		}
	}
	double addDensity(double addDensity){
		double oldDensity = m_density;
		m_density = addDouble(m_density,addDensity,1.0);
		m_txDensity.setText(""+m_density);
		initializeCellsStatus();
		return oldDensity;
	}
	double addDouble(double data,double add){
		data += add;
		data *= 10000000;
		int n = (int)(data+0.5);
		return (double)n/10000000;
	}
	double addDouble(double data,double add,double max){
		if(data+add > max)
			data -= max;
		return addDouble(data,add);
	}
	double addDouble(double data,double add,double max,double min){
		if(data+add > max){
			data = min;
			return addDouble(data,0);
		}else{
			return addDouble(data,add);
		}
	}

	/** MainPanel̃|C^ێ */
	MainPanel m_mainPanel = null;
	JLabel m_statusLabel = null;
	void setMainPanel(MainPanel mainPanel,JLabel statusLabel){
		m_mainPanel = mainPanel;
		m_statusLabel = statusLabel;
	}
	void stopExecute(){
		if(m_mainPanel != null){
			m_mainPanel.stopThread();
		}
	}
	/** ̃Z\NX */
	public class Unit {
		int m_xOrder,m_yOrder,m_zOrder;
		int m_xPosition=0,m_yPosition=0,m_width=0,m_height=0;
		boolean m_status = false;
		boolean m_statusNext = false;
		int m_nStatusTrueCount=0;

		boolean recalc(){
			return false;
		}
		void setOrder(int x,int y,int z){
			m_xOrder = x;
			m_yOrder = y;
			m_zOrder = z;
		}
		int getXOrder(){
			return m_xOrder;
		}
		int getYOrder(){
			return m_yOrder;
		}
		int getZOrder(){
			return m_zOrder;
		}
		void setLocation(int x,int y,int width,int height){
			m_xPosition = x;
			m_yPosition = y;
			m_width = width;
			m_height = height;
		}
		Color getStatusTrueColor(){
			return Color.blue;
		}
		void paint(Graphics g){
			g.drawRect(m_xPosition,m_yPosition,m_width,m_height);
			if(m_status == true){
				Color col = g.getColor();
				g.setColor(getStatusTrueColor());
				g.fillRect(m_xPosition+1,m_yPosition+1,m_width-1,m_height-1);
				g.setColor(col);
			}
		}
		void setInitialState(boolean status){
			setDefaultState();
			if(status == true)
				setStatus(true);
			else
				setStatus(false);
		}
		void setDefaultState(){
			setStatus(false);
		}
		void setStatus(boolean status){
			if(status == true)
				m_nStatusTrueCount++;
			else
				m_nStatusTrueCount = 0;
			m_status = status;
		}
		void copyStatus(Unit unit){
			m_status = unit.m_status;
			m_statusNext = unit.m_statusNext;
			m_nStatusTrueCount = unit.m_nStatusTrueCount;
		}
		boolean getStatus(){
			return m_status;
		}
		boolean getStatusNext(){
			return m_statusNext;
		}
		int getStatusTrueCount(){
			return m_nStatusTrueCount;
		}
		void setStatusNext(boolean status){
			m_statusNext = status;
		}
		void update(){
			setStatus(m_statusNext);
		}
	}
	/** ZIuWFNg */
	Unit m_cellular[][][];
	/** ZIuWFNg̍őliZIuWFNg𐶐ƂɒlZbgj*/
	int m_cellularXMax=0;
	int m_cellularYMax=0;
	int m_cellularZMax=0;
	void initializeCellsStatus(){
		for(int z=0;z<m_cellularZMax;z++){
			for(int y=0;y<m_cellularYMax;y++){
				for(int x=0;x<m_cellularXMax;x++){
					m_cellular[z][y][x].setDefaultState();
				}
			}
		}
		Vector vec = new Vector();
		int y = m_cellularYMax-1;
		for(int z=0;z<m_cellularZMax;z++){
			for(int x=0;x<m_cellularXMax;x++)
				vec.add(new Integer(z*m_cellularXMax+x));
		}
		int max = m_cellularZMax*m_cellularXMax;

		/* o蕪UĔzu */
		int carcount = (int)(max*m_density);
		int d_short = (int)(max/carcount);
		int d_long_count = max-carcount*d_short;
		int getpoint = 0;

		/* Math.random͓SEEDgpBł́AႤV[hiԁjgp */
		Random rand = new Random();
		for(int cnt=0;cnt<(int)(max*m_density);cnt++){
			Integer n;
			switch(m_initialiPosition){
			case 0:
				/* ramdom Ɉʒuzu */
				n = (Integer)vec.remove((int)(rand.nextDouble()*vec.size()));
				break;
			case 1:
				/* Öʒu珇ԂɈʒuzu (ԏa؂̂Ђǂ) */
				int remvpoint = 10;
				if(vec.size() <= remvpoint)
					n = (Integer)vec.remove(vec.size()-1);
				else
					n = (Integer)vec.remove(remvpoint);
				break;
			case 2:
				/*@o蕪UĔzu */
				if(cnt < d_long_count){
					getpoint += d_short;
					n = (Integer)vec.remove(getpoint);
				}else{
					getpoint += d_short-1;
					n = (Integer)vec.remove(getpoint);
				}
				break;
			default:
				System.out.println("m_initialiPosition error - "+m_initialiPosition);
				return;
			}
			m_cellular[(int)(n.intValue()/max)][y][(int)(n.intValue()%max)].setInitialState(true);
		}
		for(Enumeration en=vec.elements();en.hasMoreElements();){
			Integer n = (Integer)en.nextElement();
			m_cellular[(int)(n.intValue()/max)][y][(int)(n.intValue()%max)].setInitialState(false);
		}
	}
	void initializeCellsLocation(Dimension size){
		int cellx = (int)(size.getWidth()/m_cellularXMax);
		int celly = (int)(size.getHeight()/m_cellularYMax);
		int initx = (int)((size.getWidth()-(cellx*m_cellularXMax))/2);
		int inity = (int)((size.getHeight()-(celly*m_cellularYMax))/2);
		for(int z=0;z<m_cellularZMax;z++){
			for(int y=0;y<m_cellularYMax;y++){
				for(int x=0;x<m_cellularXMax;x++){
					m_cellular[z][y][x].setLocation(initx+x*cellx,inity+y*celly,cellx,celly);
				}
			}
		}
	}
	void paintCells(Graphics g){
		Color colBack = g.getColor();
		g.setColor(Color.black);
		for(int z=0;z<m_cellularZMax;z++){
			for(int y=0;y<m_cellularYMax;y++){
				for(int x=0;x<m_cellularXMax;x++)
					m_cellular[z][y][x].paint(g);
			}
		}
		g.setColor(colBack);
	}
	boolean createUnit(Integer xOrder,Integer yOrder,Integer zOrder){
		return false;
	}
	boolean executeCells(){
		return false;
	}
}
