// Copyright (C) 2001 by Nakada,Toyohisa. All Rights Reserved.
import java.awt.*;
import javax.swing.*;
import java.util.*;

/**
 * Stochastic traffic cellular automation (STCA) f̎B
 * f̓éANagel,K.: Phys. Rev. E, Vol. 52, P.4655-4672Q
 * ܂ACellRCCA͂̃NXgĂ݂̂Ȃ̂ŁAf[^W@\̑́A
 * ɎĂB
 * @author Nakada,Toyohisa
 */
public class CellSTCA extends CellTraffic{
	int m_collectX = 1;

	double m_downSpeed = 0.0;
	JTextField m_txDownSpeed = new JTextField(""+m_downSpeed);
	void setDisplayElements(Container control,Container left){
		super.setDisplayElements(control,left);
		left.add(new JLabel(" Pvd"));
		left.add(m_txDownSpeed);
	}
	void applyDisplayElements(){
		super.applyDisplayElements();
		try{
			m_downSpeed = Double.parseDouble(m_txDownSpeed.getText().trim());
		}catch(NumberFormatException e){
		}
	}

	double addDownSpeed(double add){
		double old = m_downSpeed;
		m_downSpeed = addDouble(m_downSpeed,add,1.0,0.0);
		m_txDownSpeed.setText(""+m_downSpeed);
		return old;
	}

	Object createUnitInstance(){
		return new UnitSTCA();
	}

	CellSTCA(){
		if(Collect.isCollect()==true){
			m_collect = new Collect();
			m_collect.initialize(getClass().getName()+".csv");
		}else{
			m_collect = null;
		}
	}
	public class UnitSTCA extends CellTraffic.UnitTraffic {
	}
	Object createCarInstance(){
		return new CarSTCA();
	}
	public class CarSTCA extends CellTraffic.Car {
		/** a؂𔲂ĂAPDO̎ԂɒǂĂ܂AQDő呬xɒBÂǂ炩
		  * ܂ł̎ԂL^B */
		int m_countOfTimeEscapedFromJams = -1;
		int m_countOfTimeEscapedFromJamsCollect = -1;
		/** a؂𔲂ĂAPDO̎ԂɒǂĂ܂AQDő呬xɒBÂǂ炩
		  * ̎̑x */
		int m_lastVelocityEscapedFromJamsCollect = -1;

		/** a؂ɓĂ鎞ԁBa؂ɓĂԂ͂̕ϐCNgĂB
		  * a؂甲ɁA̕ϐ m_countStopCollect ɃRs[B */
		int m_countStop = 0;
		int m_countStopCollect = 0;
		/** I[oCh\bh */
		void copy(Car car){
			super.copy(car);
			m_countStop = ((CarSTCA)car).m_countStop;
			m_countStopCollect = ((CarSTCA)car).m_countStopCollect;

			m_countOfTimeEscapedFromJams = ((CarSTCA)car).m_countOfTimeEscapedFromJams;
			m_countOfTimeEscapedFromJamsCollect = ((CarSTCA)car).m_countOfTimeEscapedFromJamsCollect;
			m_lastVelocityEscapedFromJamsCollect = ((CarSTCA)car).m_lastVelocityEscapedFromJamsCollect;
		}
		/** I[oCh\bh */
		void setInitialParam(){
			super.setInitialParam();

			m_countStop = 0;
			m_countStopCollect = 0;
			m_countOfTimeEscapedFromJams = -1;
			m_countOfTimeEscapedFromJamsCollect = -1;
			m_lastVelocityEscapedFromJamsCollect = -1;
			m_velocityMax = 5;
			m_velocityMin = 0;
			/* x̏l_̏ꍇ 
			m_velocityNext = m_velocity = (int)(Math.random()*100%(m_velocityMax-m_velocityMin+1))
				+m_velocityMin;*/
			/* xlŒ̏ꍇ */
			m_velocityNext = m_velocity = 4;
		}

		void setLocation(int x,int y,int z){
			super.setLocation(x,y,z);
			if(x == m_collectX){
				m_collectFlagSpeed = m_velocityNext;
				m_collectFlag = 1;
			}
		}
		boolean recalc(){
			// OmF
			int progress=1;
			int position=m_x;
			for(;progress<=m_velocity;progress++){
				position = m_x+progress;
				if(position >= m_cellularXMax){
					// 悪Ȃꍇ
					position -= m_cellularXMax;
				}
				if(m_cellular[m_z][m_y][position].getStatus() == true){
					// Ԃꍇ
					if(position == 0)
						position = m_cellularXMax-1;
					else
						position--;
					break;
				}
			}
			progress--;
			m_progress = progress;
			if(progress != m_velocity){
				// xi߂Ȃꍇ
				if(progress < m_velocityMin)
					m_velocityNext = m_velocityMin;
				else
					m_velocityNext = progress;

				// aؒEỏxv̏ꍇ
				if(m_countOfTimeEscapedFromJams != -1){
					m_countOfTimeEscapedFromJamsCollect = m_countOfTimeEscapedFromJams;
					m_lastVelocityEscapedFromJamsCollect = progress;

					// initialize
					m_countOfTimeEscapedFromJams = -1;
				}
			}else{
				// xi߂ꍇ
				if(m_velocity != m_velocityMax)
					m_velocityNext = m_velocity+1;

				// aؒEỏxv̏ꍇ
				if(m_countOfTimeEscapedFromJams != -1){
					m_countOfTimeEscapedFromJams++;
					if(m_velocity == m_velocityMax){
						// ő呬xɒB_ŁAvI
						m_countOfTimeEscapedFromJamsCollect = m_countOfTimeEscapedFromJams;
						m_lastVelocityEscapedFromJamsCollect = progress;

						// initialize
						m_countOfTimeEscapedFromJams = -1;
					}
				}
			}
			m_xNext = position;
			if(m_x != m_xNext){
				// ̎ԃXebvœꍇ

				// Zɓo^ĂԂ폜ĐVZ֓o^
				((UnitTraffic)m_cellular[m_z][m_y][m_x]).removeCar();
				((UnitTraffic)m_cellular[m_z][m_y][m_xNext]).setCar(this);

				// ̎ԃXebv܂ŎԂ~܂Ăꍇ
				// ܂ǍvZŏa؂甲ꍇ
				if(m_countStop != 0){
					// a؂甲ƂL^邽߂̕ϐɁAa؂Ŏ~܂Ă
					// vZ (m_countStop) ۑB
					m_countStopCollect = m_countStop;
					m_countStop = 0;

					// a؂𔲂Ẳv邽߂̎ԃX^[g
					m_countOfTimeEscapedFromJams = 1;
				}
			}else{
				// ̎ԃXebvŁAi߂Ȃꍇ
				m_countStop++;
			}
			if(Math.random() <= m_downSpeed){
				if(m_velocityNext > m_velocityMin){
					m_velocityNext--;
				}
			}
			if(m_collect!=null)
				collectData();
			return true;
		}
		int m_collectFlag = 0;
		int m_collectFlagSpeed = 0;
		/** f[^̋L^Bf[^́ASTEP̏ԂL^B
		  * ۂɐi񂾋Xs[hƂĊϑ邽߂ɁAm_xNext-m_x 
		  * Xs[hƂ邽߂łBm_velocityNext,m_velocity̐lA
		  * ۂɓȂƂ̂ŁAʒux[XŌvZ邱ƂɂB
		  * ʒux[Xőxo߂ɂ́AÖʒuƂ̔rƂȂ邪A
		  * Öʒuł͂ȂÄʒuLĂ\Ȃ̂ŁA
		  * ̎STEP̏ԂL^悤ɂȂB
		  */
		void collectData(){
			// XgbvĂԂoɃZbgϐ m_countStopCollect `FbN
			// ԂςȂ̎́Am_countStopCollect͏ɂOZbgĂB
			// xԂXgbvāAēxoɂ̓o܂ł̃Xebv
			// m_countStopCollectϐɋL^B̋L^ꂽf[^́Am_collect
			// AŏB
			if(m_countStopCollect != 0){
				m_collect.setDataCountStop(m_countStopCollect);
				m_countStopCollect = 0;
			}

			// a؂𔲂鎞̉xv
			if(m_countOfTimeEscapedFromJamsCollect != -1){
				m_collect.setDataCountOfTimeAndVelocityEscapedFromJams(m_countOfTimeEscapedFromJamsCollect,m_lastVelocityEscapedFromJamsCollect);
				m_countOfTimeEscapedFromJamsCollect = -1;
				m_lastVelocityEscapedFromJamsCollect = -1;
			}

			// v|Cgʉ߂`FbN
			int checkX = m_x<=m_xNext ? m_x : m_x-m_cellularXMax;
			int checkVelocity = m_xNext-checkX;

			// ̎Ԃɐiދixjintŕۑ
			m_collect.setDataAllPosition((int)checkVelocity);
			if(checkX <= m_collectX && m_collectX <= m_xNext){
				if(m_xNext == m_collectX){
					// v|Cgŗ~܂ꍇ
					if(m_collectFlag == 0)
						m_collectFlagSpeed = checkVelocity;
					m_collectFlag++;
				}else{
					// v|Cgʂ蔲ꍇ
					if(m_collectFlag > 0){
						// ȑOA~܂Ăēoꍇ
						m_collect.setDataCheckPoint((double)(m_collectFlagSpeed+checkVelocity)/(m_collectFlag+1));
					}else{
						// Cɒʂ蔲ꍇ
						m_collect.setDataCheckPoint((double)checkVelocity);
					}
					m_collectFlag = 0;
					m_collectFlagSpeed = 0;
				}
			}
			return;
		}
	}
}
