// Copyright (C) 2001 by Nakada,Toyohisa. All Rights Reserved.
import java.util.*;
import java.io.*;

/**
 * f[^W@\NXB̃NXŁAf[^ۑꏊAۑ@
 * LqĂBCellSTCACellRCCA͂̃NX̃CX^XɃf[^^݂̂
 * ̃NXAf[^𐮌`ăt@CɗƂB
 * @author Nakada,Toyohisa
 */
public class Collect{
	/** XebvłP̃f[^Ƃ邩肷ϐ */
	int m_unitCalcCount = 1000;
	/** ŏXebṽf[^̂Ă邩ivȂj肷ϐ */
	int m_ignoreCalcCount = 1000;	
	/** f[^WȂꍇ́A̕ϐfalseZbg*/
	static boolean m_isCollect = false;

	static boolean isCollect(){
		return m_isCollect;
	}
	static void setIsCollect(boolean status){
		m_isCollect = status;
	}

	/** f[^Z[utH_ */
	final String m_saveDirectory = "data";
	/** Z[ut@C */
	String m_saveFilename = m_saveDirectory + "/";
	void initialize(String filename){
		m_saveFilename += filename;
		initData();
		initialFile();
	}
	synchronized void initialFile(){
		File dir = new File(m_saveDirectory);
		if(dir.exists() == false)
			dir.mkdir();
		try{
			if((new File(m_saveFilename)).exists() == false)
				writeFile(
					"param-density,param-speeddown,param-rearconf,param-numberOfCellsOfRearConf,"+
					"probability of jam,"+
					"velocity 0 count,velocity 1 count,velocity 2 count,"+
					"velocity 3 count,velocity 4 count,velocity 5 count,"+
					"sumOfVelocity,distance,aveOfVelocity,density,carCount,"+
					"countofCarEscapedFromJam,countofStepEscapedFromJam,"+
					"countJam,lengthJam,"+
					"countOfCarsCollectedEscapedFromJams,countOfTimeEscapedFromJams,lastVelocityEscapedFromJam,"+
					"PlbOccur 0-1,PlbOccur 2-3,PlbOccur 4,"+
					"calcCount");
		}catch(Exception e){
			System.out.println(e);
		}
	}

	boolean m_nextParameter = false;
	/** f[^L^̂ӂ߂ǂ`FbN */
	boolean isNextParameter(){
		return m_nextParameter;
	}
	void initNextParameter(){
		m_nextParameter = false;
	}
	/** 1XebvԂ̌vZIƂ̒ʒm󂯂郁\bh */
	boolean endOneCalc(double data1,double data2,double data3,int data4){
		m_calcCount++;

		if(m_calcCount <= m_ignoreCalcCount)
			return true;

		if(m_calcCount == m_unitCalcCount+m_ignoreCalcCount){
			double aveOfVelocity;
			double density;
			double distance;
			if(m_carCount == 0){
				aveOfVelocity = 0;
				density = 0;
				distance = 0;
			}else{
				/*
				   x@@䐔       /@
				   @@@@m_carCount /  aveOfVelocity*m_calcCount
				   ԓ  =                      / 䐔
				             = aveOfVelocity*m_calcCount / m_carCount
				*/

				aveOfVelocity = m_sumOfVelocity/m_carCount;
				density = (double)m_carCount/(aveOfVelocity*m_calcCount);
				distance = aveOfVelocity*m_calcCount/m_carCount;
			}
			if(m_cellularMax==0)
				m_jam = 0;
			else
				m_jam = (double)m_velocity0Count/(m_cellularMax*m_unitCalcCount);

			double countofStepEscapedFromJam;
			if(m_countofCarEscapedFromJam==0)
				countofStepEscapedFromJam = 0;
			else
				countofStepEscapedFromJam = m_allCountofStepEscapedFromJam/m_countofCarEscapedFromJam;

			double countJam = (double)m_countJam/m_unitCalcCount;
			double LengthJam = (double)m_samOfJamLength/m_unitCalcCount;

			writeFile(""+
				data1+","+data2+","+data3+","+data4+","+
				m_jam+","+m_velocity0Count+","+m_velocity1Count+","+m_velocity2Count+","+m_velocity3Count+","+m_velocity4Count+","+m_velocity5Count+","+
				m_sumOfVelocity+","+distance+","+aveOfVelocity+","+density+","+m_carCount+","+
				m_countofCarEscapedFromJam+","+countofStepEscapedFromJam+","+
				countJam+","+LengthJam+","+
				m_countOfCarsCollectedEscapedFromJams+","+m_countOfTimeEscapedFromJams+","+m_lastVelocityEscapedFromJams+","+
				m_PlbOccur0+","+m_PlbOccur1+","+m_PlbOccur2+","+
				m_unitCalcCount);

			// initialize data
			initData();
			m_nextParameter = true;
		}
		return true;
	}
	boolean writeFile(String data){
		// t@Cɏo
		try {
			PrintWriter pw = new PrintWriter(new FileWriter(m_saveFilename,true));
			pw.println(data);
			pw.close();
		}catch(IOException e){
			System.out.println(e);
			return false;
		}
		return true;
	}
	int m_cellularMax = 0;
	void setSellularMax(int cell){
		m_cellularMax = cell;
	}
	double m_jam = 0;
	double getJam(){
		return m_jam;
	}

	/** data */
	int m_calcCount = 0;
	int m_carCount = 0;
	int m_velocity0Count = 0;
	int m_velocity1Count = 0;
	int m_velocity2Count = 0;
	int m_velocity3Count = 0;
	int m_velocity4Count = 0;
	int m_velocity5Count = 0;
	double m_sumOfVelocity = 0;
	int m_countofCarEscapedFromJam = 0;
	double m_allCountofStepEscapedFromJam = 0;
	int m_countJam = 0;
	int m_samOfJamLength = 0;
	int m_countOfCarsCollectedEscapedFromJams = 0;
	int m_countOfTimeEscapedFromJams = 0;
	int m_lastVelocityEscapedFromJams = 0;
	int m_PlbOccur0 = 0;
	int m_PlbOccur1 = 0;
	int m_PlbOccur2 = 0;
	/** initialize data */
	void initData(){
		m_calcCount = 0;
		m_carCount = 0;
		m_sumOfVelocity = 0;
		m_velocity0Count = 0;
		m_velocity1Count = 0;
		m_velocity2Count = 0;
		m_velocity3Count = 0;
		m_velocity4Count = 0;
		m_velocity5Count = 0;
		m_countofCarEscapedFromJam = 0;
		m_allCountofStepEscapedFromJam = 0;
		m_countJam = 0;
		m_samOfJamLength = 0;
		m_countOfCarsCollectedEscapedFromJams = 0;
		m_countOfTimeEscapedFromJams = 0;
		m_lastVelocityEscapedFromJams = 0;
		m_PlbOccur0 = 0;
		m_PlbOccur1 = 0;
		m_PlbOccur2 = 0;
	}
	void setDataAllPosition(int data){
		if(m_calcCount < m_ignoreCalcCount)
			return;

		switch(data){
		case 0:
			m_velocity0Count++;
			break;
		case 1:
			m_velocity1Count++;
			break;
		case 2:
			m_velocity2Count++;
			break;
		case 3:
			m_velocity3Count++;
			break;
		case 4:
			m_velocity4Count++;
			break;
		case 5:
			m_velocity5Count++;
			break;
		default:
			System.out.println(getClass().toString()+" setData input error!! "+data);
			break;
		}
	}
	void setDataCheckPoint(double data){
		if(m_calcCount < m_ignoreCalcCount)
			return;

		m_carCount++;
		m_sumOfVelocity += data;
	}
	void setDataCountStop(int data){
		// ~܂Ăԁia؂ɓĂԁjo
		// ̊֐R[B̃f[^́Ao܂ł
		// STEPB
		if(m_calcCount < m_ignoreCalcCount)
			return;

		// ̎Ԃa؂甲oL^ϐ
		m_countofCarEscapedFromJam++;
		// SĂ̎Ԃ̏a؂甲ôɗvXebv
		m_allCountofStepEscapedFromJam += data;
	}
	void setDataJamCountLength(int count,int length){
		if(m_calcCount < m_ignoreCalcCount)
			return;

		m_countJam += count;
		m_samOfJamLength += length;
	}
	void setDataCountOfTimeAndVelocityEscapedFromJams(int countOfTimeEscapedFromJams,int lastVelocity){
		if(m_calcCount < m_ignoreCalcCount)
			return;
		m_countOfCarsCollectedEscapedFromJams++;
		m_countOfTimeEscapedFromJams += countOfTimeEscapedFromJams;
		m_lastVelocityEscapedFromJams += lastVelocity;
	}
	void setDataPlbOccur(int velocity){
		if(m_calcCount < m_ignoreCalcCount)
			return;

		switch(velocity){
		case 0:
		case 1:
			m_PlbOccur0++;
			break;
		case 2:
		case 3:
			m_PlbOccur1++;
			break;
		case 4:
		case 5:
			m_PlbOccur2++;
			break;
		default:
			System.out.println("ERROR !! Collect.setDataPlbOccur - "+velocity);
			return;
		}
	}
}
