// Copyright (C) 2001 by Nakada,Toyohisa. All Rights Reserved.
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.lang.reflect.*;

/**
 * ApplicatioñCɂȂNXB̃NX̐䂲ƑApplication
 * pꍇ́ARCCAPanel NXApBƎɎApplicationȂ΁A
 * ̃NX痬p΂悢B
 * @author Nakada,Toyohisa
 */
public class MainPanel extends JPanel implements Runnable{
	/** vZԊu (ms) */
	int m_nSleepTime;
	Thread m_threadme = null;

	/** vZɍĕ`邩ݒ肷ϐ */
	int m_executeOfRepaint = 1;

	/** Z̏tOBƂɃpl̃TCYgp̂
	  * paint̒ŏĂB̎2xȂ悤ɂׂ
	  * tO */
	boolean m_cellularInitializeLocation = false;
	/** ZIuWFNgClassCX^Xێ */
	Cell m_cellObject = null;

	/** status text */
	JLabel m_statusLabel = new JLabel("status",SwingConstants.CENTER);

	MainPanel(int sleepTime){
		m_nSleepTime = sleepTime;
		m_txSleepTime = new JTextField(""+m_nSleepTime);
		m_txExecuteOfRepaint = new JTextField(""+m_executeOfRepaint);

		addComponentListener(new ComponentAdapter(){
			public void componentResized(ComponentEvent e){
				initializeLocation();
			}
		});
		setLayout(new BorderLayout());
		add(m_statusLabel,BorderLayout.SOUTH);
	}
	boolean initialize(String cellularObject,int xOrder,int yOrder,int zOrder){
		try{
			Class cellClass = Class.forName(cellularObject);
			m_cellObject = (Cell)cellClass.newInstance();
			m_cellObject.setMainPanel(this,m_statusLabel);
		}catch(Exception e){
			System.out.println(e);
			return false;
		}
		if(false == m_cellObject.createUnit(new Integer(xOrder),new Integer(yOrder),new Integer(zOrder))){
			System.out.println("cellObject.createUnit function was failed!");
			return false;
		}
		m_cellObject.initializeCellsStatus();
		m_cellularInitializeLocation = false;
		return true;
	}
	/** \֐B\́A2ɂ̂ݑΉĂ */
	public void paint(Graphics g){
		super.paint(g);

		if(m_cellularInitializeLocation == false)
			initializeLocation();
		m_cellObject.paintCells(g);
	}
	boolean execute(){
		return m_cellObject.executeCells();
	}
	/* Thread֐ */
	public void run(){
		Thread me = Thread.currentThread();
		int exec = 0;
		while(me == m_threadme){
			if(false == execute()){
				repaint();
				m_threadme = null;
				break;
			}
			exec++;
			if(exec%m_executeOfRepaint == 0)
				repaint();
			if(m_nSleepTime != 0){
				try{
					Thread.sleep(m_nSleepTime);
				}catch(InterruptedException e){
					System.out.println(e);
					break;
				}
			}
		}
	}
	JTextField m_txSleepTime;
	JTextField m_txExecuteOfRepaint;
	void setDisplayElements(Container control,Container left){
		left.add(new JLabel(" sleep"));
		left.add(m_txSleepTime);
		left.add(new JLabel(" repaint"));
		left.add(m_txExecuteOfRepaint);
		m_cellObject.setDisplayElements(control,left);
	}
	void applyDisplayElements(){
		try{
			m_nSleepTime = Integer.parseInt(m_txSleepTime.getText().trim());
		}catch(NumberFormatException e){
			System.out.println("sleep time "+e);
		}
		try{
			m_executeOfRepaint = Integer.parseInt(m_txExecuteOfRepaint.getText().trim());
		}catch(NumberFormatException e){
			System.out.println(" execution count of repaint "+e);
		}
		m_cellObject.applyDisplayElements();
	}
	void initializeLocation(){
		m_cellularInitializeLocation = true;
		Dimension size = new Dimension(getSize().width,getSize().height-m_statusLabel.getSize().height);
		m_cellObject.initializeCellsLocation(size);
	}
	void initializeStatus(){
		m_cellObject.initializeCellsStatus();
	}
	void startThread(){
		if(m_threadme == null){
			m_threadme = new Thread(this);
			m_threadme.start();
		}
	}
	void stopThread(){
		m_threadme = null;
	}
}
