// Copyright (C) 2001 by Nakada,Toyohisa. All Rights Reserved.
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import java.net.*;

/**
 * {plNXB̃AvP[VɁARg[@\ƈڍs
 * ꍇɂ́ÃNXgpBRg[@\͈ڍsɁAVRg[
 * Ŏgpꍇ́Aclass MainPanelڍsB
 * @author Nakada,Toyohisa
 */
public class RCCAPanel extends JPanel {
	MainPanel m_mainPanel[];
	JPanel m_leftPanel[];
	JPanel m_controlPanel;

	/** vZԊu (ms) */
	int m_nSleepTime;

	String m_itemCell[];
	int m_nSelectedTab = 0;

	JSplitPane m_spPane[];
	Object m_parent;

	RCCAPanel(Object parent,int xOrder,int yOrder,int zOrder,int sleepTime,String[] items){
		setLayout(new BorderLayout());

		m_parent = parent;
		m_itemCell = items;
		m_nSleepTime = sleepTime;
		m_mainPanel = new MainPanel[m_itemCell.length];
		m_leftPanel = new JPanel[m_itemCell.length];
		m_spPane = new JSplitPane[m_itemCell.length];

		JTabbedPane tab = new JTabbedPane();
		for(int cnt=0;cnt<m_itemCell.length;cnt++){
			m_mainPanel[cnt] = new MainPanel(m_nSleepTime);
			m_leftPanel[cnt] = new JPanel();

			m_spPane[cnt] = new JSplitPane(JSplitPane.VERTICAL_SPLIT,m_mainPanel[cnt],m_leftPanel[cnt]);
			m_spPane[cnt].setContinuousLayout(true);
			m_spPane[cnt].setOneTouchExpandable(true);

			tab.add(m_itemCell[cnt],m_spPane[cnt]);
		}
		tab.getModel().addChangeListener(new ChangeListener(){
			public void stateChanged(ChangeEvent e){
//				m_mainPanel[m_nSelectedTab].stopThread();
				SingleSelectionModel model = (SingleSelectionModel)e.getSource();
				m_nSelectedTab = model.getSelectedIndex();
			}
		});
		tab.setTabPlacement(SwingConstants.BOTTOM);
		add(tab,BorderLayout.CENTER);
		tab.setSelectedIndex(m_nSelectedTab);

		m_controlPanel = new JPanel();
		m_controlPanel.add(new JButton(acStart));
		m_controlPanel.add(new JButton(acStop));
		m_controlPanel.add(new JButton(acStep));
		m_controlPanel.add(new JButton(acInit));
		add(m_controlPanel,BorderLayout.SOUTH);

		for(int cnt=0;cnt<m_itemCell.length;cnt++){
			m_mainPanel[cnt].initialize(m_itemCell[cnt],xOrder,yOrder,zOrder);
			m_mainPanel[cnt].setDisplayElements(m_controlPanel,m_leftPanel[cnt]);
		}
	}
	boolean m_initializeSize=false;
	public void paint(Graphics g){
		if(m_initializeSize == false){
			m_initializeSize = true;
			for(int cnt=0;cnt<m_itemCell.length;cnt++){
				m_spPane[cnt].setDividerLocation(
					m_spPane[cnt].getSize().height-
					m_leftPanel[cnt].getPreferredSize().height-
					m_spPane[cnt].getDividerSize());
			}
		}
		super.paint(g);
	}
	Action acStart = new TextAction("Start") {
		public void actionPerformed(ActionEvent event){
			m_mainPanel[m_nSelectedTab].applyDisplayElements();
			m_mainPanel[m_nSelectedTab].startThread();
		}
	};
	Action acStop = new TextAction("Stop") {
		public void actionPerformed(ActionEvent event){
			m_mainPanel[m_nSelectedTab].stopThread();
		}
	};
	Action acStep = new TextAction("Step") {
		public void actionPerformed(ActionEvent event){
			m_mainPanel[m_nSelectedTab].applyDisplayElements();
			m_mainPanel[m_nSelectedTab].execute();
			m_mainPanel[m_nSelectedTab].repaint();
		}
	};
	Action acInit = new TextAction("Init") {
		public void actionPerformed(ActionEvent event){
			m_mainPanel[m_nSelectedTab].stopThread();
			m_mainPanel[m_nSelectedTab].applyDisplayElements();
			m_mainPanel[m_nSelectedTab].initializeStatus();
			m_mainPanel[m_nSelectedTab].repaint();
		}
	};
}
