// Copyright (C) 2001 by Nakada,Toyohisa. All Rights Reserved.
import java.awt.*;
import javax.swing.*;
import java.util.*;

/**
 * 1CÅ{NXB{NX́AȊOɁACellTrafficƂʗV~[V
 * NXB
 * @author Nakada,Toyohisa
 */
public class CellBasic extends Cell {
	/** ̃Z𒆐SƂΈʒu̒`<br>
	 *                                  z*9+y*3+x*/
	static final int UP_FRONT_RIGHT		=2*9+0*3+2;
	static final int UP_FRONT_CENTER	=2*9+0*3+1;
	static final int UP_FRONT_LEFT		=2*9+0*3+0;
	static final int UP_EVEN_RIGHT		=2*9+1*3+2;
	static final int UP_EVEN_CENTER		=2*9+1*3+1;
	static final int UP_EVEN_LEFT		=2*9+1*3+0;
	static final int UP_BACK_RIGHT		=2*9+2*3+2;
	static final int UP_BACK_CENTER		=2*9+2*3+1;
	static final int UP_BACK_LEFT		=2*9+2*3+0;

	static final int EVEN_FRONT_RIGHT	=1*9+0*3+2;
	static final int EVEN_FRONT_CENTER	=1*9+0*3+1;
	static final int EVEN_FRONT_LEFT	=1*9+0*3+0;
	static final int EVEN_EVEN_RIGHT	=1*9+1*3+2;
	static final int EVEN_EVEN_CENTER	=1*9+1*3+1;	// g
	static final int EVEN_EVEN_LEFT		=1*9+1*3+0;
	static final int EVEN_BACK_RIGHT	=1*9+2*3+2;
	static final int EVEN_BACK_CENTER	=1*9+2*3+1;
	static final int EVEN_BACK_LEFT		=1*9+2*3+0;

	static final int DOWN_FRONT_RIGHT	=0*9+0*3+2;
	static final int DOWN_FRONT_CENTER	=0*9+0*3+1;
	static final int DOWN_FRONT_LEFT	=0*9+0*3+0;
	static final int DOWN_EVEN_RIGHT	=0*9+1*3+2;
	static final int DOWN_EVEN_CENTER	=0*9+1*3+1;
	static final int DOWN_EVEN_LEFT		=0*9+1*3+0;
	static final int DOWN_BACK_RIGHT	=0*9+2*3+2;
	static final int DOWN_BACK_CENTER	=0*9+2*3+1;
	static final int DOWN_BACK_LEFT		=0*9+2*3+0;

	public class UnitBasic extends Cell.Unit {
		HashMap m_neighbor = new HashMap();
		void setNeighbor(Unit obj,int x,int y,int z){
			setNeighbor(obj,(z+1)*9+(y+1)*3+(x+1));
		}
		void setNeighbor(Unit obj,int neighbor){
			m_neighbor.put(new Integer(neighbor),obj);
			return;
		}
		Unit getNeighbor(int neighbor){
			return ((Unit)m_neighbor.get(new Integer(neighbor)));
		}
		boolean getNeighborStatus(int neighbor){
			Unit unit = getNeighbor(neighbor);
			if(unit == null)
				return getNoNeighborDefaultStatus();
			else
				return unit.getStatus();
		}
		boolean getNoNeighborDefaultStatus(){
			return false;
		}
	}
	Object createUnitInstance(){
		return new UnitBasic();
	}
	boolean createUnit(Integer xOrder,Integer yOrder,Integer zOrder){
		m_cellular = new Unit[zOrder.intValue()][yOrder.intValue()][xOrder.intValue()];
		m_cellularXMax=xOrder.intValue();
		m_cellularYMax=yOrder.intValue();
		m_cellularZMax=zOrder.intValue();
		for(int z=0;z<m_cellular.length;z++){
			for(int y=0;y<m_cellular[z].length;y++){
				for(int x=0;x<m_cellular[z][y].length;x++){
					try{
						m_cellular[z][y][x] = (Unit)createUnitInstance();
						m_cellular[z][y][x].setOrder(x,y,z);
					}catch(Exception e){
						System.out.println(e);
						return false;
					}
				}
			}
		}
		for(int z=0;z<m_cellular.length;z++){
			for(int y=0;y<m_cellular[z].length;y++){
				for(int x=0;x<m_cellular[z][y].length;x++){
					Unit cell = m_cellular[z][y][x];
					for(int zc=z-1;zc<=z+1;zc++){
						for(int yc=y-1;yc<=y+1;yc++){
							for(int xc=x-1;xc<=x+1;xc++){
								/* 񃂃f̂ƂɗL */
								if(!(xc==x && yc==y && zc==z)){
									int xd = xc;
									int yd = yc;
									int zd = zc;
									if(xd < 0)
										xd = m_cellular[z][y].length-1;
									else if(xd >= m_cellular[z][y].length)
										xd = 0;
									if(yd < 0)
										yd = m_cellular[z].length-1;
									else if(yd >= m_cellular[z].length)
										yd = 0;
									if(zd < 0)
										zd = m_cellular.length-1;
									else if(zd >= m_cellular.length)
										zd = 0;
									((UnitBasic)m_cellular[z][y][x]).setNeighbor(m_cellular[zd][yd][xd],xc-x,yc-y,zc-z);
								}
							}
						}
					}
				}
			}
		}
		return true;
	}
	/** */
	boolean executeCells(){
		// StatevZ
		for(int z=0;z<m_cellular.length;z++){
			for(int y=0;y<m_cellular[z].length;y++){
				if(y == m_cellular[z].length-1){
					for(int x=0;x<m_cellular[z][y].length;x++)
						m_cellular[z][y][x].recalc();
				}else{
					for(int x=0;x<m_cellular[z][y].length;x++)
						m_cellular[z][y][x].copyStatus(m_cellular[z][y+1][x]);
				}
			}
		}
		// vZʂ肷(ŐṼZĈ݁j
		for(int z=0;z<m_cellular.length;z++){
			int y = m_cellular[z].length-1;
			for(int x=0;x<m_cellular[z][y].length;x++)
				m_cellular[z][y][x].update();
		}
		return true;
	}
}
