// Copyright (C) 2001 by Nakada,Toyohisa. All Rights Reserved.
import java.awt.*;
import javax.swing.*;
import java.util.*;

/**
 * Rear Confirmation Cellular Automata (RCCA)f
 * f[^W̕@ύX́AendOneCalc\bh̒ύXB
 * @author Nakada,Toyohisa
 */
public class CellRCCA extends CellSTCA {
	/** p[^ŉf[^擾邩w肷ϐ */
	int m_dataCollectCount = 40;
	/** ̎ԃXebvIɃR[ */
	boolean endOneCalc(double data1){
		if(m_collect == null || m_collect.isCollect()==false)
			return true;
		boolean status = true;
		m_collect.endOneCalc(data1,m_downSpeed,m_rearConfirmation,m_numberOfCellsOfRearConfirmation);
		if(true == m_collect.isNextParameter()){
			m_collect.initNextParameter();
			m_dataCollectCountNow++;
			initializeCellsStatus();

			if(m_dataCollectCountNow >= m_dataCollectCount){
				m_dataCollectCountNow = 0;

				/* Ńp[^̕ύX@w肷B
				 * statusfalseZbgƃvO͎~܂ */

				if(10 == addNumberOfCellsOfRearConfirmation(1)){
					setNumberOfCellsOfRearConfirmation(0);
//					if(0.6 == addDensity(0.1))
						status = false;
				}

				/*
				if(1.0 == addRearConfirmation(0.1))
					status = false;
				*/
				/*
				if(1.0 == addRearConfirmation(0.2)){
					if(0.6 == addDownSpeed(0.1)){
						addDownSpeed(1.0);
						double od = addDensity(0.1);
						if(od == 0.1){
						}else if(od == 0.2 || od == 0.4){
							addDensity(0.1);
						}else{
							status = false;
						}
					}
				}*/
				/*
				if(1.0 == addRearConfirmation(0.1)){
					if(0.6 == addDensity(0.1))
						status = false;
				}
				*/

				/* density 0.01 - 0.1 {Ot悤
				if(0.6 == addDownSpeed(0.1)){
					addDownSpeed(1.0);	// Pvd <- 0
					if(1.0 == addRearConfirmation(0.1)){
						if(0.6 == addDensity(0.01))
							status = false;
					}
				}*/

				/* Plb̃`FbN 
				addRearConfirmation(0.00005);
				*/

				/* Pvd̃`FbN
				addDownSpeed(0.00001);
				*/

				/*
				if(1.0 == addDownSpeed(0.1)){
					if(1.0 == addRearConfirmation(0.1)){
						if(0.6 == addDensity(0.01))
							status = false;
					}
				}*/
			}

			/*
			if(0.99 == addDensity(0.02)){
				if(1.0 == addDownSpeed(0.2)){
					addRearConfirmation(0.2);
				}
			}
			*/
		}
		m_statusLabel.setText("Probability of jam = "+m_collect.getJam());
		return status;
	}

	int m_dataCollectCountNow = 0;
	/** eCar ObjectupdateR[OɁAŜƂẴf[^Ws֐ */
	void collectData(){
		if(m_collect == null)
			return;

		// Plb̊mŎۂɃXs[hグ鑀ԂTA̎̃Xs[hL^
		for(int z=0;z<m_cellularZMax;z++){
			int y = m_cellularYMax-1;
			for(int x=0;x<m_cellularXMax;x++){
				CarRCCA car = (CarRCCA)(((CellTraffic.UnitTraffic)m_cellular[z][y][x]).getCar());
				if(car != null){
					if(car.getPlbOccur()){
						// PlbNđxグĂÃ݂Xs[h velocity L^B
						// velocityNextł͂ȂB
						m_collect.setDataPlbOccur(car.getProgress());
					}
				}
			}
		}

		// a؂̌ƒvZB
		for(int z=0;z<m_cellularZMax;z++){
			int y = m_cellularYMax-1;

			boolean jam=false;
			int x = 0;
			if(m_cellular[z][y][0].getStatusNext()==true){
				// ŏ̃ZɎԂꍇAOɖ߂āiZł͈ԉEj
				// a؂̍ŏTB
				x = m_cellularXMax-1;
				for(;x>0;x--){
					if(m_cellular[z][y][x].getStatusNext()==false)
						break;
				}
				if(x == 0){
					// Sďa؂̏ꍇ
					m_collect.setDataJamCountLength(1,m_cellularXMax);
					return;
				}
			}
			int countOfJam = 0;
			int sumOfJamLength = 0;
			// ׂŹAZ̐̍ől{P
			// ׎n߂ŹA̎_ŕKԂȂ̃Z͂߂̂ŁA
			// Z̍ől{P΁AIɁASĂ̏a؂łB
			// [vIƂɁAŌオaؒEEĂƂ͂ȂĂ悢B
			int xend = x+m_cellularXMax+1;
			boolean statusOfBefore = false;
			for(;x!=xend;x++){
				int standardX = x;
				if(x >= m_cellularXMax)
					standardX -= m_cellularXMax;
				boolean status = m_cellular[z][y][standardX].getStatusNext();
				if(status == true){
					if(jam == true){
						// aؒ
						sumOfJamLength++;
					}else{
						if(statusOfBefore == true){
							// a؂̎n܂
							jam = true;
							sumOfJamLength+=2;
						}else{
							// 䂠邾B̐ɂԂ΁Aa؁B
						}
					}
				}else{
					if(jam == true){
						// a؂̏I
						countOfJam++;
						jam = false;
					}else{
						// a؂ĂȂ
					}
				}
				statusOfBefore = status;
			}
			m_collect.setDataJamCountLength(countOfJam,sumOfJamLength);
		}
	}
	double addRearConfirmation(double add){
		double old = m_rearConfirmation;
		m_rearConfirmation = addDouble(m_rearConfirmation,add,1.0,0.0);
		m_txrearConfirmation.setText(""+m_rearConfirmation);
		return old;
	}
	int addNumberOfCellsOfRearConfirmation(int add){
		int old = m_numberOfCellsOfRearConfirmation;
		m_numberOfCellsOfRearConfirmation += add;
		m_txnumberOfCellsOfRearConfirmation.setText(""+m_numberOfCellsOfRearConfirmation);
		return old;
	}
	int setNumberOfCellsOfRearConfirmation(int set){
		int old = m_numberOfCellsOfRearConfirmation;
		m_numberOfCellsOfRearConfirmation = 0;
		m_txnumberOfCellsOfRearConfirmation.setText(""+m_numberOfCellsOfRearConfirmation);
		return old;
	}

	Object createUnitInstance(){
		return new UnitRCCA();
	}
	public class UnitRCCA extends CellSTCA.UnitSTCA {
		/** Z̐F肷鎞ɁÅ֐R[B 
		  * f[^W̎͏xȂ̂ŁARgAEgقǂ */
		/*
		Color getStatusTrueColor(){
			if(m_car == null){
				return super.getStatusTrueColor();
			}else{
				if(((CarRCCA)m_car).getPlbOccur())
					return Color.red;
				else
					return super.getStatusTrueColor();
			}
		}
		*/
	}
	Object createCarInstance(){
		return new CarRCCA();
	}
	public class CarRCCA extends CellSTCA.CarSTCA {
		boolean m_PlbOccur = false;
		void setPlbOccur(boolean st){
			m_PlbOccur = st;
		}
		boolean getPlbOccur(){
			return m_PlbOccur;
		}
		void copy(Car car){
			super.copy(car);
			m_PlbOccur = ((CarRCCA)car).m_PlbOccur;
		}
		boolean recalc(){
			// eNX̌vZp
			if(false == super.recalc()){
				return false;
			}

			setPlbOccur(false);

			// mF
			if(m_velocityNext != m_velocityMax){
				if(Math.random() <= m_rearConfirmation){
					int back=1;
					// PZ 7.5 m [Nagel96: Particle hopping models and traffic flow theory]
					// ƂāA6Z = 45m ӎԂƂB
					for(;back<=m_numberOfCellsOfRearConfirmation;back++){
						int xc = m_x-back;
						if(xc < 0)
							xc += m_cellularXMax;
						if(m_cellular[m_z][m_y][xc].getStatus() == true){
							m_velocityNext++;
							setPlbOccur(true);
							break;
						}
					}
				}else{
				}
			}else{
			}
			return true;
		}
	}
	double m_rearConfirmation = 0.0;
	int m_numberOfCellsOfRearConfirmation = 6;
	JTextField m_txrearConfirmation = new JTextField(""+m_rearConfirmation);
	JTextField m_txnumberOfCellsOfRearConfirmation = new JTextField(""+m_numberOfCellsOfRearConfirmation);
	void setDisplayElements(Container control,Container left){
		super.setDisplayElements(control,left);
		left.add(new JLabel(" Plb"));
		left.add(m_txrearConfirmation);
		left.add(new JLabel(" Nclb"));
		left.add(m_txnumberOfCellsOfRearConfirmation);
	}
	void applyDisplayElements(){
		super.applyDisplayElements();
		try{
			m_rearConfirmation = Double.parseDouble(m_txrearConfirmation.getText().trim());
			m_numberOfCellsOfRearConfirmation = Integer.parseInt(
				m_txnumberOfCellsOfRearConfirmation.getText().trim());
		}catch(NumberFormatException e){
		}
	}
}
