// Copyright (C) 2001 by Nakada,Toyohisa. All Rights Reserved.
import java.awt.*;
import javax.swing.*;
import java.util.*;

/**
 * ʗV~[VpCeller Automata{NXB
 * @author Nakada,Toyohisa
 */
public class CellTraffic extends Cell {
	/** f[^Wp̃IuWFNg */
	Collect m_collect;

	public class UnitTraffic extends Cell.Unit {
		Car m_car = null;
		Car getCar(){
			return m_car;
		}
		void setCar(Car car){
			setStatusNext(true);
			m_car = car;
		}
		void removeCar(){
			setStatusNext(false);
			m_car = null;
		}
		/** superNXmethod̃I[oChB
		    statustrue͎̎(class Car)쐬B */
		void setInitialState(boolean status){
			super.setInitialState(status);
			if(status == true){
				Car car = (Car)createCarInstance();
				car.setLocation(getXOrder(),getYOrder(),getZOrder());
				m_listCar.add(car);
				setCar(car);
			}else{
				removeCar();
			}
		}

		/* Ԃ̐F@\ȂiׂēFjꍇ́ÃR[hgpBif[^Wj */
		void copyStatus(Unit unit){
			super.copyStatus(unit);
			m_car = ((UnitTraffic)unit).m_car;
		}
		/* Ԃ̐F@\ꍇ́ÃR[hgiʊmFj */
		/*
		void copyStatus(Unit unit){
			super.copyStatus(unit);
			if(((UnitTraffic)unit).m_car == null){
				m_car = null;
			}else{
				m_car = (Car)createCarInstance();
				m_car.copy(((UnitTraffic)unit).m_car);
			}
		}
		*/
	}
	Object createUnitInstance(){
		return new UnitTraffic();
	}
	boolean createUnit(Integer xOrder,Integer yOrder,Integer zOrder){
		m_cellular = new Unit[zOrder.intValue()][yOrder.intValue()][xOrder.intValue()];
		m_cellularXMax=xOrder.intValue();
		m_cellularYMax=yOrder.intValue();
		m_cellularZMax=zOrder.intValue();
		for(int z=0;z<m_cellularZMax;z++){
			for(int y=0;y<m_cellularYMax;y++){
				for(int x=0;x<m_cellularXMax;x++){
					try{
						m_cellular[z][y][x] = (Unit)createUnitInstance();
						m_cellular[z][y][x].setOrder(x,y,z);
					}catch(Exception e){
						System.out.println(e);
						return false;
					}
				}
			}
		}
		if(m_collect!=null)
			m_collect.setSellularMax(m_cellularYMax);
		return true;
	}
	void initializeCellsStatus(){
		m_listCar.removeAllElements();
		super.initializeCellsStatus();
	}
	boolean executeCells(){
		// O̎ԃXebvRs[
		for(int z=0;z<m_cellularZMax;z++){
			for(int y=0;y<m_cellularYMax-1;y++){
				for(int x=0;x<m_cellularXMax;x++){
					m_cellular[z][y][x].copyStatus(m_cellular[z][y+1][x]);
				}
			}
		}
		// ŐV̎ԃZCvZ
		Vector listDelCar = new Vector();
		for(Enumeration en=m_listCar.elements();en.hasMoreElements();){
			Car car = (Car)en.nextElement();
			if(false == car.recalc())
				listDelCar.add(car);
		}

		// recalc false ԂIuWFNg폜B
		for(Enumeration en=listDelCar.elements();en.hasMoreElements();){
			Car car = (Car)en.nextElement();
			m_listCar.remove(car);
		}
		// updateOɁAf[^Ws
		collectData();

		// vZʂ肷
		for(Enumeration en=m_listCar.elements();en.hasMoreElements();){
			Car car = (Car)en.nextElement();
			car.update();
		}
		// vZʂ肷(ŐṼZĈ݁j
		for(int z=0;z<m_cellularZMax;z++){
			int y = m_cellularYMax-1;
			for(int x=0;x<m_cellularXMax;x++)
				m_cellular[z][y][x].update();
		}
		// f[^WIuWFNg1̌vZIƂʒm
		return endOneCalc(m_density);
	}
	void collectData(){
	}
	boolean endOneCalc(double data1){
		return true;
	}
	Object createCarInstance(){
		return new Car();
	}
	Vector m_listCar = new Vector();
	public class Car {
		int m_x,m_y,m_z,m_xNext,m_yNext,m_zNext;
		int m_velocity,m_velocityNext;
		int m_velocityMax;
		int m_velocityMin;
		int m_progress;

		Car(){
			setInitialParam();
		}
		void copy(Car car){
			m_x = car.m_x;
			m_y = car.m_y;
			m_z = car.m_z;
			m_xNext = car.m_xNext;
			m_yNext = car.m_yNext;
			m_zNext = car.m_zNext;
			m_velocity = car.m_velocity;
			m_velocityNext = car.m_velocityNext;
			m_velocityMax = car.m_velocityMax;
			m_velocityMin = car.m_velocityMin;
			m_progress = car.m_progress;
		}
		int getVelocity(){
			return m_velocity;
		}
		int getVelocityNext(){
			return m_velocityNext;
		}
		int getProgress(){
			return m_progress;
		}
		void setLocation(int x,int y,int z){
			m_x = m_xNext = x;
			m_y = m_yNext = y;
			m_z = m_zNext = z;
		}
		void setInitialParam(){
			m_velocity = m_velocityNext= 1;
			m_velocityMax = 5;
			m_velocityMin = 1;
		}
		boolean recalc(){
			// false߂ƁA̎Ԃ͍폜
			return true;
		}
		void update(){
			m_velocity = m_velocityNext;
			m_x = m_xNext;
			m_y = m_yNext;
			m_z = m_zNext;
		}
	}
}
