module Main where

import Term
import Rule
import TRS
import ARIParser
import System.Environment

header :: String
header = unlines
  ["<?xml version=\"1.0\"?>",
   "<?xml-stylesheet type=\"text/xsl\" href=\"../../xml/xtcHTML.xsl\"?>",
   "<problem xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" type=\"termination\" xsi:noNamespa ceSchemaLocation=\"../../xml/xtc.xsd\">"]
   
escape :: String -> String
escape []         = ""
escape ('<' : cs) = "_lt_" ++ escape cs
escape ('>' : cs) = "_gt_" ++ escape cs
escape (c   : cs) = c : escape cs


tag :: String -> [String] -> String
tag s ts = "<" ++ s ++ ">" ++ concat ts ++ "</" ++ s ++ ">"

tag_term :: Term -> String
tag_term (V x) = tag "var" [escape x]
tag_term (F f ts) =
  tag "funapp"
    (tag "name" [escape f] : [ tag "arg" [tag_term t] | t <- ts ])

tag_rule :: Rule -> String
tag_rule (l, r) =
  tag "rule" [tag "lhs" [tag_term l], tag "rhs" [tag_term r]]

tag_funcsym :: (String, Int) -> String
tag_funcsym (f, n) =
  tag "funcsym" 
    [tag "name" [escape f], 
     tag "arity" [show n]]

tag_signature :: Signature -> String
tag_signature sig =
  tag "signature"
    [ tag_funcsym (f, n) | (f, n) <- sig ] 

tag_trs :: (TRS, TRS) -> String
tag_trs (rs, ss) =
  tag "trs"
    [tag "rules" 
       ([ tag_rule rule | rule <- rs ] ++
        [tag "relrules" [ tag_rule rule | rule <- ss ]]),
     tag_signature (TRS.signatureOf (rs ++ ss))]

tag_problem :: (TRS, TRS) -> String
tag_problem (rs, ss) =
  "<?xml version=\"1.0\"?>\n" ++
  "<?xml-stylesheet type=\"text/xsl\" href=\"../../xml/xtcHTML.xsl\"?>\n" ++
  "<problem xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " ++
  "type=\"termination\" " ++
  "xsi:noNamespaceSchemaLocation=\"../../xml/xtc.xsd\">" ++
  tag_trs (rs, ss) ++
  tag "strategy" ["FULL"] ++
  "</problem>\n"


main :: IO ()
main = do
  file : _ <- getArgs
  error_or_trs <- read_file file
  case error_or_trs of
    Left e    -> putStrLn (show e)
    Right (rs, ss) -> 
      putStr (tag_problem (rs, ss))
