module ArgumentFiltering where

import Data.List 
import Term

data AF = Collapsing Int -- 0-indexed (internally)
        | Filtering [Bool] -- only filtering, no permutation

showFiltering :: [Bool] -> String
showFiltering bs = "[" ++ intercalate ", " [ show i | (b, i) <- zip bs [(1 :: Int)..], b ] ++  "]"

-- 1-indexed for pretty printing
instance Show AF where
  show (Collapsing i) = show (i+1)
  show (Filtering bs) = showFiltering bs

type ArgumentFiltering = [(String, AF)]

apply :: ArgumentFiltering -> Term -> Term
apply _ t@(V _) = t
apply m (F f ts) =
  case lookup f m of
    Nothing -> error ("function symbol " ++ f ++ " is not found in argument filtering")
    Just (Collapsing i) -> ts !! i
    Just (Filtering bs) -> F f [ t | (t, b) <- zip ts bs, b ]

-- show functions
showArgumentFiltering :: ArgumentFiltering -> String
showArgumentFiltering m = 
  unlines [ "pi(" ++ f ++ ") = " ++ show af | (f, af) <- m ]
