module DG where

import Term
import Rule
import TRS
import DP
import Usable (tcap)
import SCC

type DPProblem = (TRS, TRS)
type DG = [(Rule,Rule)]

connectable :: TRS -> Rule -> Rule -> Bool
connectable trs (_, t) (u, _) =
  unifiable (tcap "x" trs t) (Term.rename "y" u)

dg :: Problem -> DG
dg (ps, rs, _) =
  [ (st, uv) | st <- ps, uv <- ps, connectable rs st uv]

sccs :: Problem -> [Problem]
sccs (ps, rs, m) =
  [ (scc, rs, m) | scc <- SCC.cyclic_sccs (dg (ps, rs, m)) ]