module DP where

import Term
import Rule
import TRS

-- DP problem
-- (P, R, m) where m is minimality
type Problem = (TRS, TRS, Bool)

show_problem :: Problem -> String
show_problem (ps, rs, m) =
  unlines
    ["The dependency pair problem (P, R, m):",
     "",
     "  P:",
     showTRS ps,
     "  R:",
     showTRS rs,
     "  minimality: " ++ show m ] 

-- DP(R)
dp :: TRS -> TRS
dp trs =
  [ Rule.mark (l, t)
  | (l, r) <- trs, 
    let ss = proper_subterms l,
    t@(F f _) <- subterms r,
    elem f ds && notElem t ss ] 
  where
    ds = defined_symbols trs

dominates' :: TRS -> Rule -> Bool
dominates' trs (_, r) =
  all (\f -> notElem f (defined_symbols trs)) (Term.functions r)

dominates :: TRS -> TRS -> Bool
dominates rs ss = all (dominates' rs) ss

dp_problem :: TRS -> TRS -> Maybe Problem
dp_problem rs [] = Just (dp rs, rs, True)
dp_problem rs ss
  | TRS.non_duplicating ss && dominates rs ss =
    Just (dp rs, rs ++ ss, False)
  | otherwise = Nothing

signature_of :: Problem -> Signature
signature_of (ps, rs, _) = TRS.signatureOf (ps ++ rs)