module Main where

import TRS
import DP
import ARIParser
import System.Environment

main :: IO ()
main = do
  file : _ <- getArgs
  error_or_TRS <- read_file file
  case error_or_TRS of
    Left e -> putStrLn (show e)
    Right (rs, ss) ->
      if TRS.non_duplicating ss && DP.dominates rs ss then do
        putStrLn "YES"
      else
        putStrLn "NO"
