-- Linear polynomial interpretations.

module Linear where

import Data.List

type Affine = (Int, [Int])
type Interpretation = (String, Affine)
type Algebra = [(String, (Int, [Int]))]

show_lhs :: (String, Int) -> String
show_lhs (f, n) =
  f ++ "_A(" ++
  intercalate "," [ "x" ++ show i | i <- [1..n] ] ++
  ")"

-- f_A(x_0,...,x_{n-1}) = a0 + ai_0 x0 + ... + ai_{n-1} x_{n-1}
--   where a0 in N and ai_0, ..., an in {0,1}.
 
show_a_xi :: (Int, Int) -> String
show_a_xi (1, i) = "x" ++ show i
show_a_xi (a, i) = show a ++ " x" ++ show i

show_affine :: Affine -> String
show_affine (n, as)
  | ss == []  = show n
  | n == 0    = intercalate " + " ss 
  | otherwise = intercalate " + " (show n : ss)
  where
    ss = [ show_a_xi (ai, i) | (ai, i) <- zip as [1..], ai /= 0 ]

show_interpretation :: Interpretation -> String
show_interpretation (f, affine@(_, as)) =
  show_lhs (f, length as) ++ " = " ++
  show_affine affine

show_algebra :: Algebra -> String
show_algebra a = 
  unlines [ show_interpretation f_A | f_A <- a ]
