module Precedence where

import Data.List

import Term

type Precedence = [(String, Int)]

showPrecedence' :: Precedence -> String
showPrecedence' []  = error "showPrecedence"
showPrecedence' [(f,_)] = f
showPrecedence' ((f,m) : p@((_,n) : _))
  | m == n = f ++ " = " ++ showPrecedence' p
  | m >  n = f ++ " > " ++ showPrecedence' p
  | otherwise = error "showPrecedence"

showPrecedence :: Precedence -> String
showPrecedence []  =  
  "precedence:\n\n" ++ "    empty\n\n"
showPrecedence [_] = 
  "precedence:\n\n" ++ "    empty\n\n"
showPrecedence a = 
  "precedence:\n\n" ++
  "  " ++ showPrecedence' (sortBy f a) ++ "\n\n"
  where f (_,m) (_,n) = compare n m

-- guarantee integers to be natural numbers
shift :: Precedence -> Precedence
shift pr = [ (f, n + (-m)) | (f, n) <- pr ]
  where
    m = minimum [ n | (_, n) <- pr]

-- f >= g
geqPrec :: Precedence -> Term -> Term -> Bool
geqPrec p (F f _) (F g _)
  | m <- lookup f p, n <- lookup g p = m >= n
geqPrec _ _ _ = error "geqPrec"

-- f > g
gtPrec :: Precedence -> Term -> Term -> Bool
gtPrec p (F f _) (F g _)
  | m <- lookup f p, n <- lookup g p = m > n
gtPrec _ _ _ = error "gtPrec"
