module Recursive where

import DP
import DG
import Proof

type Criterion = Problem -> IO (Maybe Subproof)

apply :: [Criterion] -> Problem -> IO (Maybe Subproof)
apply [] _ = return Nothing
apply (criterion : criteria) problem = do
  result1 <- criterion problem
  case result1 of
    Nothing    -> apply criteria problem
    Just proof -> return (Just proof)


solve_problem :: Bool -> [Criterion] -> Problem -> IO (Maybe Proof)
solve_problem oneshot criteria problem = do
  result <- solve_sccs oneshot criteria problems
  case result of
    Nothing -> return Nothing
    Just proofs -> return (Just (Node problem (SCCs problem problems) proofs))
  where problems = if oneshot then [problem] else sccs problem

solve_problems :: Bool -> [Criterion] -> [Problem] -> IO (Maybe [Proof])
solve_problems _ _ [] = return (Just [])
solve_problems oneshot criteria (problem : problems) = do
  result1 <- solve_problem oneshot criteria problem
  case result1 of
    Nothing -> return Nothing
    Just proof -> do
      result2 <- solve_problems oneshot criteria problems
      case result2 of
        Nothing -> return Nothing
        Just proofs -> return (Just (proof : proofs))

solve_scc :: Bool -> [Criterion] -> Problem -> IO (Maybe Proof)
solve_scc oneshot criteria problem = do
  result1 <- apply criteria problem
  case result1 of
    Nothing -> return Nothing
    Just (criterion_proof, subproblems) -> do
      result2 <- solve_problems oneshot criteria subproblems
      case result2 of
        Nothing -> return Nothing
        Just subproofs -> 
          return (Just (Node problem criterion_proof subproofs))          

solve_sccs :: Bool -> [Criterion] -> [Problem] -> IO (Maybe [Proof])
solve_sccs _ _ [] = return (Just [])
solve_sccs oneshot criteria (problem : problems) = do
  result1 <- solve_scc oneshot criteria problem
  case result1 of
    Nothing    -> return Nothing
    Just proof -> do
      result2 <- solve_sccs oneshot criteria problems
      case result2 of
        Nothing -> return Nothing
        Just proofs -> return (Just (proof : proofs))
