module Rule where

import Data.List
import Term

type Rule = (Term, Term)

showRule :: Rule -> String
showRule (l, r) = show l ++ " -> " ++ show r

-- Var(l -> r) = Var(l) cup Var(r)
variables :: Rule -> [String]
variables (l, r) = union (Term.variables l) (Term.variables r)

-- Fun(l -> r) = Fun(l) cup Fun(r)
functions :: Rule -> [String]
functions (l, r) = union (Term.functions l) (Term.functions r)

signatureOf :: Rule -> Signature
signatureOf (l, r) = union (Term.signatureOf l) (Term.signatureOf r) 

-- |l -> r| = |l| + |r|
size :: Rule -> Int
size (l, r) = Term.size l + Term.size r

substitute :: Rule -> Subst -> Rule
substitute (l, r) sigma =
  (Term.substitute l sigma, Term.substitute r sigma)

rename :: String -> Int -> Rule -> Rule
rename x k (l, r) = (Term.substitute l sigma, Term.substitute r sigma)
  where
    ys = union (Term.variables l) (Term.variables r)
    sigma = [ (y, V (x ++ show i)) | (y, i) <- zip ys [k :: Int ..] ]

non_duplicating :: Rule -> Bool
non_duplicating rule@(l, r) = all p (Rule.variables rule)
  where p x = count l x >= count r x

subset ::Eq a => [a] -> [a] -> Bool
subset xs ys = all p xs
  where p x = elem x ys

variableCondition :: Rule -> Bool
variableCondition (V _, _) = False
variableCondition (l, r)   = subset (Term.variables r) (Term.variables l)

-- l^# -> r^#
mark :: Rule -> Rule
mark (l, r) = (Term.mark l, Term.mark r)
