module SCC where 

import Data.List
import qualified Data.Graph
import Data.Tree

sccs_int :: (Int, Int) -> [(Int, Int)] -> [[Int]]
sccs_int (m, n) es =
  reverse [ flatten t | t <- Data.Graph.scc (Data.Graph.buildG (m,n) es) ]

index :: Eq a => [a] -> a -> Int
index xs x
  | Just i <- elemIndex x xs = i
  | otherwise = error "index"

index_edge :: Eq a => [a] -> (a, a) -> (Int, Int)
index_edge xs (x, y) = (index xs x, index xs y)

index_edges :: Eq a => [a] -> [(a, a)] -> [(Int, Int)]
index_edges vs es = [ index_edge vs e | e <- es ]

sccs :: Eq a => [(a, a)] -> [[a]]
sccs es = [ [ vs !! x | x <- xs ] | xs <- xss ]
  where
    vs = nub [ w | (u, v) <- es, w <- [u, v] ] 
    xss = sccs_int (0, length vs - 1) (index_edges vs es)

cyclic_scc :: Eq a => [(a, a)] -> [a] -> Bool
cyclic_scc es [v] = elem (v, v) es
cyclic_scc _  _   = True

cyclic_sccs :: Eq a => [(a, a)] -> [[a]]
cyclic_sccs es = [ scc | scc <- sccs es, cyclic_scc es scc ]