module TRS where
    
import Data.List
import Term
import Rule

type TRS       = [Rule]
type Overlap   = (Rule, Position, Rule, Subst)

type Equation = (Term, Term)
type ES = [Equation]

showTRS :: TRS -> String
showTRS []  = unlines ["  (empty)"]
showTRS trs = unlines [ "  " ++ showRule rule | rule <- trs ]

showEq :: Rule -> String
showEq (l, r) = show l ++ " = " ++ show r

showES :: TRS -> String
showES es = unlines [ "  " ++ showEq e | e <- es ]

signatureOf :: TRS -> [(String, Int)]
signatureOf trs = nub [ fn | rule <- trs, fn <- Rule.signatureOf rule ]

arity :: String -> TRS -> Int
arity f trs =
  case lookup f (TRS.signatureOf trs) of
    Just n -> n
    Nothing -> error ("something is wrong about the arity of the function symbol " ++ f)

substitute :: TRS -> Subst -> TRS
substitute trs sigma = [ Rule.substitute rule sigma | rule <- trs ]

variableCondition :: TRS -> Bool
variableCondition trs = all Rule.variableCondition trs

variables :: TRS -> [String]
variables trs = nub [ x | rule <- trs, x <- Rule.variables rule ]

-- Fun(R)

functions :: TRS -> [String]
functions trs = nub [ f | rule <- trs, f <- Rule.functions rule ]

functionsES :: ES -> [String]
functionsES es = TRS.functions es

-- D_R

defined_symbols :: TRS -> [String]
defined_symbols trs = nub [ f | (F f _, _) <- trs ]

substituteES :: TRS -> Subst -> TRS
substituteES = TRS.substitute

non_duplicating :: TRS -> Bool
non_duplicating trs = all Rule.non_duplicating trs

diff :: TRS -> TRS -> TRS
diff trs1 trs2 =
  [ rule | rule <- trs1, notElem rule trs2 ]