-- Usable rules.

module Usable where

import Term
import TRS


tcap' :: String -> Int -> TRS -> Term -> (Int, Term)
tcap' x k _   (V _) = (k + 1, V (x ++ show k))
tcap' x k trs (F f ts)
  | any (\(l, _) -> unifiable u l) trs = (k + 1, V (x ++ show k))
  | otherwise = (m, u)
  where    
    (m, us) = tcap_list x k trs ts
    u = F f us 

tcap_list :: String -> Int -> TRS -> [Term] -> (Int, [Term])
tcap_list _ k _   []       = (k, [])
tcap_list x k trs (t : ts) = (n, u : us)
    where
      (m, u)  = tcap' x k trs t
      (n, us) = tcap_list x m trs ts

tcap :: String -> TRS -> Term -> Term
tcap x trs t = u
  where (_, u) = tcap' x 0 trs t

tcap_args :: String -> TRS -> Term -> Term
tcap_args _ _ t@(V _)  = t
tcap_args x trs (F f ts) = F f us
  where (_, us) = tcap_list x 1 trs ts

new_usable_rules :: TRS -> TRS -> TRS -> TRS
new_usable_rules ps rs us =
  [ rule
  | rule@(l, _) <- rs,
    notElem rule us,  
    let l' = Term.rename "y" l,
    let p u = unifiable l' (tcap_args "x" rs u),
    any p [ u | (_, t) <- ps, u@(F _ _) <- subterms t ] ]

-- UR(P,R,U)
usable_rules' :: TRS -> TRS -> TRS -> TRS
usable_rules' [] _  us = us
usable_rules' ps rs us = usable_rules' us' rs (us' ++ us)
  where us' = new_usable_rules ps rs us

-- UR(P,R) = UR(P,R,U)
usable_rules :: TRS -> TRS -> TRS
usable_rules ps rs = usable_rules' ps rs []

