-- Parallel critical pairs (Toyama 1981).

module PCP where

import Data.List
import Term
import Rule
import TRS

data LabeledTerm =
    LV String
  | LF String [(Rule, Rule, Subst)] [LabeledTerm]
  deriving Show

label' :: Int -> TRS -> Term -> Maybe Term -> (Int, LabeledTerm)
label' k _ (V x) _ = (k, LV x)
label' k trs s@(F f ss) mt =
  (k1, LF f [ ((l, r), Rule.substitute (l, r) sigma, sigma)
            | rule <- trs,
              case mt of
                Nothing -> True
                Just t -> not (Rule.variant (s, t) rule),
              let (l, r) = Rule.rename ("x" ++ show k ++ "_") 1 rule,
              Just sigma <- [mgu l s] ]
            lts)
  where (k1, lts) = labelTerms (k+1) trs ss

labelTerms :: Int -> TRS -> [Term] -> (Int, [LabeledTerm])
labelTerms k _   []       = (k, [])
labelTerms k trs (s : ss) = (k2, lt : lts)
  where
    (k1, lt)  = label' k trs s Nothing
    (k2, lts) = labelTerms k1 trs ss

label :: TRS -> Term -> Term -> LabeledTerm
label trs l r = lt
  where (_, lt) = label' 0 trs l (Just r)

pcp1 :: LabeledTerm -> [(Term, TRS, [String], Subst, Bool)]
pcp1 (LV x) = [(V x, [], [], [], False)]
pcp1 (LF f redexes lts) =
    [ (t, [lr], Term.variables s, sigma, True)
    | (lr, (s, t), sigma) <- redexes ] ++
    [ (F f ts, nub (concat rs), nub (concat xss), concat sigmas, or bs)
    | tuples <- sequence [ pcp1 lti | lti <- lts ],
      let (ts, rs, xss, sigmas, bs) = unzip5 tuples
    ]

-- This definition includes parallel critical pairs 
-- of form t <-||-_P . -> u with P empty.
pcp :: TRS -> [(Term, (TRS, Rule), [String], Term)]
pcp trs =
  nub [ (t, (rs, rule), xs, Term.substitute r sigma)
      | rule <- trs,
        let (l, r) = Rule.rename "y" 1 rule,
        (t, rs, xs, sigma, True) <- pcp1 (label trs l r) ]

pcpeak :: TRS -> [(Term, (TRS, Rule), [String], Term, Term)]
pcpeak trs =
  nub [ (t, (rs, rule), xs, Term.substitute l sigma, Term.substitute r sigma)
      | rule <- trs,
        let (l, r) = Rule.rename "y" 1 rule,
        (t, rs, xs, sigma, True) <- pcp1 (label trs l r) ]
