-- Parallel Critical Pair Closing

module PCPS (sh22, pcpsWithC, hm11) where

import Data.List
import Term
import TRS
import Result
import Rewriting
import RTermination
import PCP (pcpeak)
import qualified Proof as Proof

proof :: TRS -> TRS -> TRS -> String -> String
proof trs cs ps crProof =
  Proof.subproof
    "Composable parallel critical pair system (Shintani and Hirokawa 2022)."
    trs cs
    (unlines
      [ "The parallel critical pair system PCPS(R,C) is:"
      , ""
      , Proof.showTRS ps
      , "The TRS R is locally confluent and PCPS(R,C)/R is terminating."])
    crProof

-- Shintani and Hirokawa 2022
sh22 :: RTermination -> Int-> Criterion -> TRS -> IO Result
sh22 tt k cr trs
  | TRS.leftLinear trs && wcr k trs =
      pcpsCriterion tt cr k trs css
  | otherwise = return MAYBE
  where
    css = trs : [xs | xs <- power trs, length xs /= n]
    n = length trs

-- initializeCs :: TRS -> [TRS]
-- initializeCs trs =
--   trs : [c | c1 <- power (trs \\ c0),
--              let c = c1 ++ c0,
--              -- c =/= trs
--              length c /= n]
--   where
--     c0 = makeC0 trs
--     n  = length trs
-- 
-- makeC0 :: TRS -> TRS
-- makeC0 trs =
--   nub $ concat
--     [[a,b] | a <- trs, b <- trs,
--              (t,s,u) <- cpeak2 [b] [a],
--              looping [(s,t),(s,u)] trs]

-- **ASSUME that C is confluent**
pcpsWithC :: RTermination -> Int-> TRS -> Criterion
pcpsWithC tt k trs cs
  | TRS.leftLinear trs && wcr k trs = do
    m <- tt (pcps k trs cs) trs
    case m of
      YES _ -> return (YES (proof trs cs ps "(assumption)"))
      _     -> return MAYBE
  | otherwise = return MAYBE
  where ps = pcps k trs cs

hm11 :: RTermination -> Int -> Criterion
hm11 tt k trs
  | TRS.leftLinear trs && wcr k trs =
      pcpsCriterion tt emptyTRS k trs [[]]
  | otherwise = return MAYBE

pcpsCriterion :: RTermination -> Criterion -> Int -> TRS -> [TRS] -> IO Result
pcpsCriterion _ _ _ _ [] = return MAYBE
pcpsCriterion tt cr k trs (cs:css) = do
  m <- tt ps trs
  case m of
    NO _  -> pcpsCriterion tt cr k trs css
    MAYBE -> pcpsCriterion tt cr k trs css
    YES _ -> do
      v <- cr cs
      case v of
        YES txt -> return (YES (proof trs cs ps txt))
        _       -> pcpsCriterion tt cr k trs css
  where ps = pcps k trs cs

-- ordered by smaller elements to bigger elements
power :: [a] -> [[a]]
power [] = [ [] ]
power (x : xs) = yss ++ [ x : ys | ys <- yss ]
  where yss = power xs

emptyTRS :: Criterion
emptyTRS [] = return (YES "# Emptiness.\n\nThe empty TRS is confluent.\n")
emptyTRS _  = return MAYBE

pcps :: Int -> TRS -> TRS -> TRS
pcps k r c = nub
  [rule | (t, (rulesL, ruleR), _, s, u) <- pcpeak r,
          not (TRS.subsume c (ruleR:rulesL)),
          not (joinable k c (t,u)),
          rule <- [(s,t),(s,u)]]

joinable :: Int -> TRS -> (Term,Term) -> Bool
joinable k trs (s,t) =
  intersect
    (at_most_k_steps k trs s)
    (at_most_k_steps k trs t) /= []

wcr :: Int -> TRS -> Bool
wcr k trs = all (joinable k trs) (cp trs)
