module Result where

import Data.List (find)
import TRS

data Result =
    YES String
  | NO  String
  | MAYBE

instance Show Result where
  show (YES s) = "YES\n\n" ++ s
  show (NO s)  = "NO\n\n" ++ s
  show MAYBE   = "MAYBE\n"

type Criterion = TRS -> IO Result

isYES, isNO :: Result -> Bool
isYES (YES _) = True
isYES _       = False
isNO (NO _)   = True
isNO _        = False

yesWhen, noWhen :: Bool -> Result
yesWhen True  = YES "yes"
yesWhen False = MAYBE
noWhen True   = NO "no"
noWhen False  = MAYBE

lookupYES :: [Result] -> Maybe Result
lookupYES rs = find isYES rs

lookupNO :: [Result] -> Maybe Result
lookupNO rs = find isNO rs

lookupResult :: [Result] -> Maybe Result
lookupResult rs
  | Just x <- lookupYES rs = Just x
  | Just x <- lookupNO rs  = Just x
  | otherwise              = Nothing

-- find first non-MAYBE result from criteria
oneOf :: [Criterion] -> Criterion
oneOf [] _ = return MAYBE
oneOf (thm:criteria) trs = do
  v <- thm trs
  case v of
    MAYBE -> oneOf criteria trs
    _ -> return v

