module Labeling where

import Rule

type Labeling a = [(Rule, a)]

show_labeling :: (String, Labeling Int) -> String
show_labeling (name, phi) =
  unlines
    [ "  " ++ name ++ "(" ++ show_rule rule ++ ") = " ++ show n
    | (rule, n) <- phi ]

lookup_by :: (a -> a -> Bool) -> a -> [(a,b)] -> Maybe b
lookup_by _ _ [] = Nothing
lookup_by p x ((y, z) : a)
  | p x y     = Just z
  | otherwise = lookup_by p x a

label_of_rule :: Labeling a -> Rule -> a
label_of_rule phi rule
  | Just e <- lookup_by Rule.variant rule phi = e
  | otherwise = error "label_of_rule"

labels_of_rules:: Labeling a -> [Rule] -> [a]
labels_of_rules phi rules = [ label_of_rule phi rule | rule <- rules ]
