-- Critical Pair Closing

module CPS2 (sh22,hm11) where

import Data.List
import Term
import Rule
import TRS
import Result
import Rewriting

-- joinable
joinable :: Int -> TRS -> Term -> Term -> Bool
joinable k trs s t =
  intersect
    (at_most_k_steps k trs s)
    (at_most_k_steps k trs t) /= []

-- local confluence
wcr :: Int -> TRS -> Bool
wcr k trs =
  all (\(s, t) -> joinable k trs s t) (cp trs)


-- CPS(R, C)
criticalPeaks :: TRS -> TRS -> [(Term, Term, Term)]
criticalPeaks rs cs =
  [ (replace (Term.substitute l2 sigma) (Term.substitute r1 sigma) p,
     Term.substitute l2 sigma,
     Term.substitute r2 sigma)
  | rule2 <- rs,
    let (l2, r2) = Rule.rename "y" 1 rule2,
    rule1 <- rs,
    not (elem rule1 cs && elem rule2 cs),
    let (l1, r1) = Rule.rename "x" 1 rule1,
    p <- functionPositions l2,
    let l2p = subtermAt l2 p,
    Just sigma <- [mgu l2p l1],
    p /= [] || not (Rule.variant rule1 rule2) ]

cps :: TRS -> TRS -> TRS
cps rs cs =
  TRS.unique
  [ rule | (t, s, u) <- criticalPeaks rs cs, 
           rule <- [(s, t), (s, u)] ]

power' :: [a] -> [[a]]
power' [] = [ [] ]
power' (x : xs) = 
  yss ++ [ x : ys | ys <- yss ]
  where yss = power' xs

power :: [a] -> [[a]]
power xs = xs : [ ys | ys <- power' xs, length ys < n ]
  where n = length xs

proof :: TRS -> TRS -> TRS -> String
proof rs cs ps =
  "# critical pair system (Shintani and Hirokawa 2022).\n\n" ++
  "Consider the left-linear TRS R is:\n\n" ++
  showTRS rs ++ "\n" ++
  "Let C be the following subset of R:\n\n" ++
  (if cs == [] then "  (empty)\n\n" else showTRS cs ++ "\n") ++
  "The critical pair system CPS(R,C) is:\n\n" ++
  (if ps == [] then "  (empty)\n\n" else showTRS ps ++ "\n") ++
  "Since all pairs in CP(R) are joinable and CPS(R,C)/R is terminating, confluence of R follows from that of C.\n"

cpsCriterion1 :: (TRS -> Criterion) -> Criterion -> [TRS] -> Criterion
cpsCriterion1 _  _  []         _  = return MAYBE
cpsCriterion1 sn cr (cs : css) rs = do
  m <- sn ps rs
  case m of
    MAYBE -> cpsCriterion1 sn cr css rs
    NO _  -> cpsCriterion1 sn cr css rs
    YES _ -> do
      result <- cr cs
      case result of
        YES proofForC ->
          return (YES (proof rs cs ps ++ "\n" ++ proofForC))
        _ -> cpsCriterion1 sn cr css rs
  where
    ps = cps rs cs


sh22 :: Int -> (TRS -> Criterion) -> Criterion -> Criterion
sh22 k sn cr rs
  | TRS.leftLinear rs && wcr k rs =
      cpsCriterion1 sn cr (power rs) rs
  | otherwise = return MAYBE

emptyTRS :: Criterion
emptyTRS [] = return (YES "# emptiness\n\nThe empty TRS is confluent.\n")
emptyTRS _  = return MAYBE

hm11 :: Int -> (TRS -> Criterion) -> Criterion
hm11 k sn rs
  | TRS.leftLinear rs && wcr k rs =
      cpsCriterion1 sn emptyTRS [ [] ] rs
  | otherwise = return MAYBE
