module CeTA where

import XML
import System.IO
import System.Process
import Text.ParserCombinators.Parsec

data Result = CERTIFIED | REJECTED (String, ParseError)

-- Scanners

keyword :: String -> Parser ()
keyword s = do
  spaces
  _ <- string s
  spaces

-- Parsers

parseCERTIFIED :: Parser ()
parseCERTIFIED = do
  keyword "CERTIFIED"
  eof

-- Running an SMT solver.

execute :: String -> String -> IO String
execute tool input = do
  (Just hin, Just hout, _, _) <-
    createProcess (proc tool ["/dev/stdin"]) {
      std_in  = CreatePipe,
      std_out = CreatePipe }
  hPutStr hin input
  hClose hin
  hGetContents hout

certify :: String -> Certificate -> IO Result
certify ceta certificate = do
  -- putStrLn ("-- CeTA input --\n" ++ showCertificate certificate ++ "\n")
  s <- execute ceta (showCertificate certificate)
  -- putStrLn ("-- CeTA output --\n" ++ s ++ "\n--\n")
  case parse parseCERTIFIED "(stdin)" s of
    Left e -> return (REJECTED (s, e))
    Right () -> return CERTIFIED
