module NonConfluence (nonWCR, isNotConfuent, notJoinable, tcap, tcap') where

import Term
import TRS
import Result

proof :: String -> String -> String -> String
proof t s u = unlines ["peak", "", peak, "is not joinable"]
  where
    peak = unlines [t, "*<-", s, "->*", u] 

nonWCR :: Criterion
nonWCR trs =
  case nonJoinables trs of
    [] -> return MAYBE
    (t,s,u):_ -> return (NO (proof (show t) (show s) (show u)))

isNotConfuent :: TRS -> Bool
isNotConfuent trs = nonJoinables trs /= []

nonJoinables :: TRS -> [(Term,Term,Term)]
nonJoinables trs =
  [(t,s,u) | (t,_,s,u) <- cpeak trs, notJoinable trs (t,u)]

notJoinable :: TRS -> (Term,Term) -> Bool
notJoinable trs (t,u) = 
  not (unifiable (tcap' trs "x" t) (tcap' trs "y" u))

-- before applying TCAP function, replacing all variables in the target term to
-- correspoding new fresh constants
tcap' :: TRS -> String -> Term -> Term
tcap' trs x t = tcap trs x [] (Term.substitute t sigma)
  where
    -- COPS TRS format assumes that function symbols and variables are
    -- distinct.  So "F v []" is a fresh function symbol.
    sigma = [(v, F v []) | v <- Term.variables t]

showPosition :: Position -> String
showPosition p = concat (map show p)

-- assume there is no varialbe that has the prefix x 
-- `tcap trs "x" [0] (V "x0")` is invalid application
tcap :: TRS -> String -> [Int] -> Term -> Term
tcap _ x ps (V _) =
  -- replace new fresh variable
  V (x ++ showPosition ps)
tcap trs x ps (F f ts)
  | any (\(l,_) -> unifiable u l) trs = V (x ++ showPosition ps)
  | otherwise = u
  where
    us = [tcap trs x (ps ++ [p]) t | (t,p) <- zip ts [1 :: Int ..]]
    u  = F f us
