-- Parallel Critical Pair Closing

module PCPS (sh22, pcpsWithC, hm11) where

import Data.List
import Term
import Rule
import TRS
import Rewriting
import SN
import PCP (pcpeak)
import Result
import CompositionalCriteria
import qualified Proof as Proof

proof :: TRS -> TRS -> TRS -> String -> String
proof trs cs ps crProof =
  Proof.subproof
    "Compositional parallel critical pair system (Shintani and Hirokawa 2022)."
    trs cs
    (unlines
      [ "The parallel critical pair system PCPS(R,C) is:"
      , ""
      , Proof.showTRS ps
      , "All pairs in PCP(R) are joinable and PCPS(R,C)/R is terminating."])
    crProof

-- Shintani and Hirokawa 2022
sh22 :: RTermination -> Int-> Criterion -> Criterion
sh22 tt k cr trs
  | TRS.leftLinear trs && wcr k trs =
      pcpsCriterion tt cr k trs css
  | otherwise = return MAYBE
  where
    css = trs : [xs | xs <- power trs, length xs /= n]
    n = length trs

pcpsWithC :: RTermination -> Int-> CompCriterion
pcpsWithC tt k trs cs
  | TRS.leftLinear trs && wcr k trs = do
      m <- tt (pcps k trs cs) trs
      case m of
        YES _ -> return (YES (proof trs cs ps ""))
        _     -> return MAYBE
  | otherwise = return MAYBE
  where ps = pcps k trs cs

hm11 :: RTermination -> Int -> Criterion
hm11 tt k trs
  | TRS.leftLinear trs && wcr k trs =
      pcpsCriterion tt emptyTRS k trs [[]]
  | otherwise = return MAYBE

pcpsCriterion :: RTermination -> Criterion -> Int -> TRS -> [TRS] -> IO Result
pcpsCriterion _ _ _ _ [] = return MAYBE
pcpsCriterion tt cr k trs (cs:css) = do
  m <- tt ps trs
  case m of
    YES _ -> do
      v <- cr cs
      case v of
        YES crproof ->
          return (YES (proof trs cs ps crproof))
        NO _ | subset trs cs ->
          return v
        _ ->
          pcpsCriterion tt cr k trs css
    _  -> pcpsCriterion tt cr k trs css
  where
    ps = pcps k trs cs

pcps :: Int -> TRS -> TRS -> TRS
pcps k r c = nub
  [rule | (t, (rulesL, ruleR), _, s, u) <- pcpeak r,
          not (TRS.subsume c (ruleR:rulesL)),
          not (joinable k c (t,u)),
          rule <- [(s,t),(s,u)]]

joinable :: Int -> TRS -> (Term,Term) -> Bool
joinable k trs (s,t) =
  intersect
    (at_most_k_steps k trs s)
    (at_most_k_steps k trs t) /= []

wcr :: Int -> TRS -> Bool
-- wcr k trs = all (joinable k trs) (cp trs)
wcr k trs = all (joinable k trs)
  [(t,u) | (t,_,_,_,u) <- pcpeak trs] 
