module WST where

import TRS

showProblem :: (TRS, TRS) -> String
showProblem (strictRules, weakRules) = 
  "(VAR" ++ concat [ " " ++ x | x <- TRS.variables (strictRules ++ weakRules) ] ++ ")\n" ++
  "(RULES\n" ++ 
  unlines ([ show l ++ " -> "  ++ show r | (l, r) <- strictRules ] ++ 
           [ show l ++ " ->= " ++ show r | (l, r) <- weakRules   ]) ++
  ")\n"