open Term
open Substitution
open Format

type t = Rule.t * int list * Rule.t * Substitution.t

let count = ref 0

let fresh () = incr count; sprintf "___ac_cps_x%d" !count

let rename (l, r) =  
  let s = [ x, V (fresh ()) | x <- variables l ] in
  (substitute s l, substitute s r)

(* AC Overlaps *)
let overlap_aux ac rule1 rule2 =
  let l1, r1 = rename rule1
  and l2, r2 = rename rule2 in
  [ (l1, r1), p, (l2, r2),  u
  | p <- function_positions l2; 
    ac_unifs <- [Ac_subst.unify ac ((subterm_at p l2),l1)];
    ac_unifs <> [] &&
    (p <> [] || not (Rule.variant (l1, r1) (l2, r2))); u <- ac_unifs ] 

let overlap2 ac rules1 rules2 = 
  Listset.unique
    [ x | rule1 <- rules1; rule2 <- rules2; 
          x <- overlap_aux ac rule1 rule2 ]

let overlap ac rules = overlap2 ac rules rules

(* AC critical pairs *)

let cp_of_overlap ((l1, r1), p, (l2, r2), mu) =
  (Term.substitute mu (replace l2 r1 p), Term.substitute mu r2)

let cp2 ac rules1 rules2 = 
  [ cp_of_overlap o | o <- overlap2 ac rules1 rules2 ]

let cp ac rules = cp2 ac rules rules
