let finally handler f x =
  let r = try f x with e -> handler (); raise e in 
  handler (); r

exception Failed

let rec try_loop f = function
  | [] -> raise Failed
  | x :: xs -> try f x with Failed -> try_loop f xs;;

let rec find_some p l =
  match l with
  | [] -> None
  | x :: xs -> 
      match p x with
      | None -> find_some p xs
      | x -> x

let num = Num.num_of_int

let assoc ~default x alist = 
  try List.assoc x alist with Not_found -> default

let open_in_do ?path f =
  match path with 
  | None -> f stdin
  | Some file -> 
      let in_channel = open_in file in
      finally (fun () -> close_in in_channel) f in_channel

let open_out_do ?path f =
  match path with 
  | None -> f stdout
  | Some file -> 
      let out_channel = open_out file in
      finally (fun () -> close_out out_channel) f out_channel


let popen_in cmd f =
  let in_channel = Unix.open_process_in cmd in
  let close () = Unix.close_process_in in_channel in 
  try 
    let result = f in_channel in
    let process_status = close () in
    (result, process_status)
  with 
    e -> ignore (close ()); raise e

let read_file ?path parse =
  open_in_do ?path (fun ch -> parse (Stream.of_channel ch))

let timer f =
  let t0 = Sys.time () in
  let y = f () in
  (y, Sys.time () -. t0)

(*
let scan ~pat s = 
  Array.to_list 
    (Array.map Array.to_list (Pcre.extract_all ~full_match:false ~pat s))
*)

let rec index_aux n list x =
  match list with
  | [] -> raise Not_found
  | y :: ys when x = y -> n
  | _ :: ys -> index_aux (n + 1) ys x

let index list x = index_aux 0 list x

let invert alist = List.map (fun (x, y) -> (y, x)) alist;;

let sort_by f list = 
  let cmp x y = Pervasives.compare (f x) (f y) in
  List.sort cmp list

let pair x y = (x, y)

open Num

let rec fib = function
  | 0 | 1 as n -> num n
  | n -> fib (n - 2) +/ fib (n - 1)
