#!/usr/bin/ruby

require 'uri'

def read_status file, timeout
  h = {}
  return nil unless FileTest.exist? file
  open(file) {|f| 
    f.readlines.each {|s| 
      a = s.scan(/(\S+)\s*=\s*(\S+);/)[0] 
      if a != nil && a.length == 2
        h[a[0]] = a[1] 
      end
    }
  }
  if h['time'].to_f > timeout.to_f
    h['status'] = 'TIMEOUT'
    h['time'] = timeout
  end
  h
end

def summarize files, dirs, timeout
  files.map {|file|
    base = File.dirname(file) + "/" + File.basename(file, ".trs")
    base.gsub!(/^\.\//) { "" }
    status = {}
    dirs.each {|dir| 
      status[dir] = read_status("#{dir}/#{base}.status", timeout)
    }
    { 'base' => base, 'status' => status }
  }
end

def statistics dirs, res, summary, comparison
  hh = {}
  for dir in dirs
    hh[dir] = { 
      'YES' => { 'number' => 0, 'time' => 0 },
      'NO' => { 'number' => 0, 'time' => 0 },
      'MAYBE' => { 'number' => 0, 'time' => 0 },
      'TIMEOUT' => { 'number' => 0, 'time' => 0 },
      'ERROR' => { 'number' => 0, 'time' => 0 }  }
  end
  c = 0
  for a in summary
    for dir in dirs
      next if a['status'][dir] == nil
      next if a['status'][dir]['status'] == nil
      hh[dir][a['status'][dir]['status']]['number'] += 1
      hh[dir][a['status'][dir]['status']]['time'] += a['status'][dir]['time'].to_f
    end
    if comparison == :u && dirs.any? {|dir| (a['status'][dir] && a['status'][dir]['status'] == res[dir])}
      c += 1 
    elsif comparison == :i && dirs.all? {|dir| (a['status'][dir] && a['status'][dir]['status'] == res[dir])}
      c += 1 
    end
  end
  unless comparison == :none
    p c; exit
  else
    hh
  end
end

def natcmp a, b
  return 0  if a == "" && b == ""
  return -1 if a == "" 
  return 1  if b == "" 
  aa = a.scan(/^(\d*)(.*)$/)[0]
  bb = b.scan(/^(\d*)(.*)$/)[0]
  c = aa[0].to_i <=> bb[0].to_i
  c == 0 ? alphacmp(aa[1], bb[1]) : c
end

def alphacmp a, b
  return 0  if a == "" && b == ""
  return -1 if a == "" 
  return 1  if b == "" 
  aa = a.scan(/^(\d*)(.*)$/)
  bb = b.scan(/^(\d*)(.*)$/)
  c = aa[0] <=> bb[0]
  c == 0 ? natcmp(aa[1], bb[1]) : c
end

comparison = :none

if ARGV[0] =~ /^-u/
  comparison = :u
  ARGV.shift
elsif ARGV[0] =~ /^-i/
  comparison = :i
  ARGV.shift
end

timeout = ARGV.shift.to_i
dirs = []
res = {}
ARGV.each {|s| 
  a = s.scan(/([^ \t\n\r:]+):?(\S+)?/)[0]
  dirs << a[0]
  res[a[0]] = a[1] ? a[1] : "YES"
}

summary = summarize(Dir.glob("*.trs").sort {|x,y| natcmp(x,y) }, dirs, timeout)
#summary = summarize(Dir.glob("*.trs").sort, dirs, timeout)
hh = statistics dirs, res, summary, comparison

l = ["\"id\""]
for dir in dirs
  l.push "\"#{dir}\""
  l.push "time"
end
puts l.join(",")
for a in summary
  l = []
  l.push "#{a['base']}"
  for dir in dirs
    status = a['status'][dir]
    if status && status['status']
      l.push "\"#{status['status']}\""
      l.push status['time'].to_f
    else
      l.push ""
      l.push ""
    end
  end
  puts l.join(",")
end
