#!/usr/bin/ruby

require 'uri'
require 'csv'

if ARGV.size != 1
  puts "makehtml.rb <csv_file>" 
  exit 1
end

a = CSV.readlines(ARGV[0])

# summarize data
# initialize variables for summary table
states = ["YES","NO","MAYBE","TIMEOUT","ERROR"]
count = {}  # the number of YES/NO/etc..
time = {}   # total time
for s in states 
  count[s] = {}
  time[s] = {}
  1.step(a[0].length - 1, 2) {|j|
    count[s][j] = 0 
    time[s][j] = 0.0
  }
end
# count up
for i in 1 ... a.length
  1.step(a[i].length - 1, 2) {|j|
     s = a[i][j]
     s.chomp! if s
     if states.include?(s) 
       count[s][j] += 1
       time[s][j] += a[i][j+1].to_f
     end
  }
end

# output html
no_link = false
puts <<EOS
<?xml version="1.0" encoding="utf-8" ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>Experiments</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<style type="text/css">
body {
  margin: 0;
  padding: 0;
  font-family: Helvetica,sans-serif;
}
h1 { color: #44f; font-size: x-large; text-align: center; }
h2 { color: #a00;
     margin-top: 1em;
     margin-left: -1em;
     text-align: left;
     font-size: x-large;
     border-bottom: dotted 3px #daa;
}
.content {
  margin-left: 2em;
  margin-right: 2em;
  clear: right;
}
table {
  border-top: solid 1px #ccc;
  border-bottom: solid 1px #ccc;
}
thead   { color: black; background: #bbe; }
tr.count { color: black; background: white; }
.count { font-weight: bold; }
tr.time  { color: black; background: #ddf;  }

tr.even { color: black; background: white; }
tr.odd  { color: black; background: #ddf;  }

.YES           { font-weight: bold; color: green; }
.YES a:link    { font-weight: bold; color: green; }
.YES a:visited { font-weight: bold; color: green; }

.NO           { font-weight: bold; color: red; }
.NO a:link    { font-weight: bold; color: red; }
.NO a:visited { font-weight: bold; color: red; }

.ERROR           { font-weight: bold; color: black; background: red; }
.ERROR a:link    { font-weight: bold; color: black; background: red; }
.ERROR a:visited { font-weight: bold; color: black; background: red; }

.MAYBE           { font-weight: bold; color: #e88; }
.MAYBE a:link    { font-weight: bold; color: #e88; }
.MAYBE a:visited { font-weight: bold; color: #e88; }

.TIMEOUT { font-weight: normal; color: red; background: #dd0; }
</style>
</head>
<body>
<div class="content">
<h1>Experiments</h1>
EOS

puts "<h2>Summary</h2>"
puts "<table summary=\"Summary\">"
puts "<thead>"
puts "<tr>"
puts "<th>status</th>"
1.step(a[0].length - 1, 2) {|j|
  puts "<th>#{a[0][j]}</th>"
}
puts "</tr>"
puts "</thead>"
puts "<tbody>"
for s in states
  puts "<tr class=\"count\">"
  puts "<td class=\"#{s}\">#{s}</td>"
  1.step(a[0].length - 1, 2) {|j|
    puts "<td>#{count[s][j]}</td>"
  }
  puts "</tr>"
  puts "<tr class=\"time\">"
  puts "<td>(sec)</td>"
  1.step(a[0].length - 1, 2) {|j|
    puts "<td>#{format("%.2f",time[s][j])}</td>"
  }
  puts "</tr>"
end
puts "</tbody>"
puts "</table>"

puts "<h2>Individual results</h2>"
puts "<table summary=\"Individual results\">"
puts "<thead>"
puts "<tr>"
puts "<th>#{a[0][0]}</th>"
1.step(a[0].length - 1, 2) {|j|
  puts "<th>#{a[0][j]}</th>"
}
puts "</tr>"
puts "</thead>"
puts "<tbody>"
for i in 1 ... a.length do
  puts "<tr class=\"#{(i % 2 == 0) ? "even" : "odd"}\">"
  puts "<td><a href=\"#{URI.encode(a[i][0])}.trs\">#{a[i][0]}</a></td>"
  1.step(a[i].length - 1, 2) {|j|
    if a[i][j]
      txt = "#{a[0][j]}/#{File.dirname(a[i][0])}/#{File.basename(a[i][0], ".trs")}.txt"
      if FileTest.exist?(txt)
	puts "<td class=\"#{a[i][j]}\"><a href=\"#{URI.encode(txt)}\" title=\"#{URI.encode(txt)}\">#{a[i][j][0,1]}:#{format("%.2f",a[i][j+1])}</a></td>"
      else
	puts "<td class=\"#{a[i][j]}\">#{a[i][j][0,1]}:#{format("%.2f",a[i][j+1])}</td>"
      end
    else
      puts "<td>?</td>"
    end
  }
  puts "</tr>"
end
puts "</tbody>"
puts "</table>"

puts <<EOS
</div>
</body>
</html>
EOS
