{
open Lexing
open Minismt_parser
}

let ident = ['_' 'a'-'z' 'A'-'Z'] ['_' 'a'-'z' 'A'-'Z' '0'-'9']*
let num = '-'? ['0'-'9']+

rule lex = parse
  | [' ' '\r' '\t' '(' ')'] {  lex lexbuf }
  | '\n'   { new_line lexbuf; lex lexbuf }
  | '='    { EQ }
  | ident as s { ID s }
  | num   as s { NUM (int_of_string s) }
  | eof    { EOF }
  | _ { OTHER }
