%{
open Lexing
open Parsing
%}

%token <string> ID
%token <int> NUM
%token EQ EOF OTHER

%type <(string * int) list option> toplevel
%start toplevel

%%

toplevel:
  | ID assignments EOF { match $1 with "sat" -> Some $2 | _ -> None }
  | { None }

assignments:
  | assignment assignments { $1 :: $2 }
  | { [] }

assignment:
  | ID EQ NUM  { ($1, $3) }
