#!/usr/bin/ruby -Eutf-8

require 'cgi'
require 'uri'
require 'csv'

$csv = CSV.readlines('a.csv')
$data = {}
$tags = {}
$csv[1 .. -1].each {|a| 
  id = a[0].to_i
  $data[id] = a 
  $tags[id] = (1 ... $csv[0].length).map {|i|
    case a[i]
    when 'YES'; $csv[0][i] + ".YES"
    when 'NO'; $csv[0][i] + ".NO"
    else nil
    end
  }.compact.sort
}

$SAFE = 1

$TRSs = 100

def span c, x
  c == nil ? x : "<span class=\"#{c}\">#{x}</span>"
end

def read_trs filename
  a = IO.readlines(filename).join.scan(/\(|\)|,|[^\(\),\s]+|\s+/)
  vars = []
  result = ""
  for s in a
    c = nil
    case s
    when "VAR", "RULES", "STRATEGY", "COMMENT"; mode, c = s, "k"
    when "->", "(", ")", ",", /\s+/; c = nil
    else
      case mode
      when "VAR"; vars << s; c = "v"
      when "RULES"; c = vars.include?(s) ? "v" : "f" 
      end
    end
    result += span(c, CGI.escapeHTML(s))
  end
  result
end

def pager q, page, pages
<<EOS
  <div class="pager">
  #{
  (page <= 1) ?
    "":
    "<a href=\"./?q=#{q}&amp;page=#{page-1}\" class=\"cursor\">&laquo; PREV</a>"
  }
  #{ 
  (1 .. pages).map {|i|
    (i == page) ?
      "<span class=\"current\">#{i}</span>" :
      "<a href=\"./?q=#{q}&amp;page=#{i}\">#{i}</a>"
  }.join(" ")
  }
  #{
  (page >= pages) ?
    "":
    "<a href=\"./?q=#{q}&amp;page=#{page+1}\" class=\"cursor\">NEXT &raquo;</a>"
  }
  </div>
EOS
end

def result_class(id)
  if ! $tags[id].grep(/\.YES/).empty?
    "confluent"
  elsif ! $tags[id].grep(/.NO/).empty?
    "non_confluent"
  else 
    "maybe"
  end
end
 

cgi = CGI.new

q = cgi.params['q'][0] =~ /(.+)/ ? $1.downcase : ""
q_html = CGI.escapeHTML(q)
q_uri = URI.encode(q)
inclusion = []
exclusion = []
q.split.each {|tag| 
  if tag[0] == ?- 
    exclusion << tag[1 .. -1]
  else 
    inclusion << tag
  end
}
page = cgi.params['page'][0]  =~ /(\d+)/ ? $1.to_i : 1

# tag/id search
ids = Dir.glob("*.trs").map {|file|
  File.basename(file, ".trs").to_i
}.select {|id| 
  $tags[id] != nil &&
  inclusion.all? {|tag| ($tags[id] + [id.to_s]).include?(tag) } &&
  exclusion.all? {|tag| ! ($tags[id] + [id.to_s]).include?(tag) } 
}.sort

# grep search
if ids.empty? && q =~ /\S/
  re = Regexp.new(Regexp.escape(q), Regexp::IGNORECASE)
  ids = Dir.glob("*.trs").map {|file|
    File.basename(file, ".trs").to_i
  }.select {|id| 
    File.open("#{id}.trs") {|f| 
      ! f.readlines.grep(re).empty?
    }
  }.sort
end

print <<EOS
Content-type: text/html; charset=utf-8

<?xml version="1.0" encoding="utf-8" ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
   "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<link rel="stylesheet" href="style-wide.css" type="text/css" media="all" />
<link rel="stylesheet" href="cops.css"       type="text/css" media="all" />
<link rel="index" href="./" />
<link rev="made" href="./" />
<link rel="shortcut icon" href="favicon.ico" />
<title>Cops: Confluence Problems Database</title>
</head>
<body>
<div class="lang_sel">&nbsp;</div>
<div class="all">
<div class="header">
  <div class="subtitle"><br />Confluence Competition</div>
  <div class="logo">&nbsp;</div>
</div>
<div class="main_menu">
  <a href ="http://coco.nue.riec.tohoku.ac.jp/">Home</a>
  <a class="active" href="http://coco.nue.riec.tohoku.ac.jp/cops/">Cops</a>
  <a href="http://coco.nue.riec.tohoku.ac.jp/tools/">Tools</a>
  <a href="http://coco.nue.riec.tohoku.ac.jp/2011/">2012</a>
</div>

<div class="content">

<h2>Confluence Problems (Cops)</h2>

<div class="search">
<form action="./" method="get">
<p>
#{ 
q == "" ?
  "<span class=\"current\">all</span>" : 
  "<a href=\"./\">all</a>" 
} |
#{
q == "-confluent -non_confluent" ?
  "<span class=\"current\">open problems</span>" : 
  "<a href=\"./?q=-confluent+-non_confluent\">open problems</a>"
} |
#{
q != "" && q != "-confluent -non_confluent" ?
  "<span class=\"current\">search:</span>" :
  "search:" 
}
<input tabindex="1" accesskey="f" type="text" name="q" size="30"
maxlength="100" value=\"#{q_html}\" />
<input tabindex="2" accesskey="g" id="search" type="submit" value="" alt="go" />
</p>
</form>
</div>
<div class="results">
<form action="./zip.cgi" method="post" class="summary">
<p>#{ids.length} problems found.
<input tabindex="3" accesskey="d" type="submit" value="DOWNLOAD .zip" />
<input type="hidden" name="ids" value="#{ids.join(",")}" />
</p>
</form> 
#{pager q_html, page, (ids.length.to_f / $TRSs).ceil}
#{
ids[(page - 1) * $TRSs, $TRSs].map {|id|
<<EOS
<div class="#{result_class(id)}">
<h3><a href="#{id}.trs">#{id}.trs</a></h3>
<pre class="trs">#{read_trs "#{id}.trs"}</pre>
<div class="tags">
tags:
#{$tags[id].map {|s| "<a href=\"./?q=#{s}\">#{s}</a>" }.join(" ")}
</div>
</div>
EOS
}.join
}
#{pager q_html, page, (ids.length.to_f / $TRSs).ceil}
</div>
<div class="note">
<ul>
<li>Problems for CoCo 2012 will be tagged with coco2012.</li>
<li>Tag information: <a href="tags.csv">tags.csv</a></li>
<li><a href="Changes.txt">Changes.txt</a></li>
</ul>
</div>
</div>
</div>
</body>
</html>
EOS
