open Minismt
open Term
open Substitution
open Overlap
open Wcr
open Format

let minimal ~geq xs = 
  Listx.unique [ x | x <- xs; List.for_all (fun y -> not (geq x y) || x = y) xs ]

let rec emb xs ys =
  match xs, ys with
  | _, [] -> true
  | [], _ :: _ -> false
  | x :: xs, y :: ys -> (x = y && emb xs ys) || emb xs (y :: ys)

let pairwise_emb (xs, ys) (xs', ys') = emb xs xs' && emb ys ys'

let rec lookup rule = function
  | [] -> invalid_arg "Rl.lookup"
  | (rule', x) :: _ when Rule.variant rule rule' -> x
  | _ :: a -> lookup rule a

let rec rewrite_root a s = 
  [ x, substitute (pattern_match l s) r 
  | (l, r), x <- a; is_instance_of s l ]

let rewrite a s =
  Listx.unique
    [ x, replace s t p 
    | p <- positions s; x, t <- rewrite_root a (subterm_at p s) ]

let rec jj1 a k ss =
  if k = 0 then ss else 
  minimal ~geq:(fun (xs1, s1) (xs2, s2) -> s1 = s2 && emb xs1 xs2) 
    (ss @ 
     jj1 a (k - 1) 
       [ xs @ [x], t | xs, s <- ss; x, t <- rewrite a s ])
	
let jj a k (s, t) = 
  let l1 = jj1 a k [[], s] 
  and l2 = jj1 a k [[], t] in
  minimal ~geq:pairwise_emb [ xs, ys | xs, s' <- l1; ys, t' <- l2; s' = t' ]

let psi a b = function
  | [] -> C []
  | c :: ds -> 
      C (Eq (b, c) :: [ D [Gt (a, d); Gt (b, d)] | d <- ds])

let phi_ab a b cs =
  D [ C (psi a b cs2 :: [ Gt (a, c) | c <- cs1 ]) 
       | cs1, cs2 <- List.combine (Listx.prefix cs) (Listx.suffix cs) ]

let phi a k ((rule1, p, rule2, mu) as o) =
  D [ C [phi_ab (lookup rule1 a) (lookup rule2 a) cs;
	       phi_ab (lookup rule2 a) (lookup rule1 a) ds]
       | cs, ds <- jj a k (cp_of_overlap o) ]

let rl a rules k = 
  C [ phi a k o | o <- overlap rules ]

let try_finally x f g =
  try let y = f x in g x; y with e -> g x; raise e

let solve ~tool k rules =
  if Rules.linear rules then
    let a = [ rule, sprintf "x%d" i | i, rule <- Listx.ix ~i:1 rules ] in
    match sat ~tool [ x | _, x <- a ] (rl a rules k) with
    | Some b -> Some [ rule, List.assoc x b | rule, x <- a ]
    | None -> None
  else 
    None
