type t = Term.t * Term.t

val print : Format.formatter -> t -> unit

val print_with : string -> Format.formatter -> t -> unit

val equal : t -> t -> bool

val hash : t -> int

val compare : t -> t -> int

val variables : t -> string list

val functions : t -> string list

val signature : t -> Signature.t

val is_non_erasing : t -> bool

val is_non_duplicating : t -> bool

(* well formed *)
val wf : t -> bool

val linear : t -> bool

val left_linear : t -> bool

val right_linear : t -> bool

val variable_condition : t -> bool

val rename : t -> t

val variant : t -> t -> bool

val remove : t list -> t -> t list
