type t = Rule.t list

val print : Format.formatter -> t -> unit

val print_with : string -> Format.formatter -> t -> unit

val variables : t -> string list

val functions : t -> string list

val signature : t -> Signature.t

val defined_symbols : t -> string list

val is_non_overlapping : t -> bool

val is_non_duplicating : t -> bool

val variable_condition : t -> bool

val is_constructor_system : t -> bool

val wf : t -> bool

val linear : t -> bool

val left_linear : t -> bool

val right_linear : t -> bool

val remove : t -> t -> t

val flatten : string list -> t -> t
