#!/usr/bin/ruby

def read_status file
  h = {}
  open(file) {|f| 
    f.readlines.each {|s| 
      a = s.scan(/(\S+)\s*=\s*(\S+);/)[0]
      h[a[0]] = a[1] if a != nil && a.length == 2
    }
  }
  h
end

def skip status_file, timeout
  if FileTest.exist? status_file
    h = read_status status_file
    h["status"] == "YES" ||
    h["status"] == "NO" ||
    h["status"] == "MAYBE" ||
    (h["status"] == "TIMEOUT" && (print "-- #{h["timeout"].to_i} (old) vs #{timeout}\n"; h["timeout"].to_i >= timeout))
  else
    false
  end
end

if ARGV.size != 2 && ARGV.size != 4
  puts "runhydra [-l list_of_files] <command> <timeout>"
  exit 1
end

list_of_files = nil
if ARGV.size == 4
  ARGV.shift
  list_of_files = ARGV.shift
end

command = ARGV[0]
dir = File.basename(command, ".sh")
p dir
timeout = ARGV[1].to_i

Dir.mkdir dir unless FileTest.exist? dir

if list_of_files 
  files = IO.readlines(list_of_files).map {|s| s.chop }
else
  files = Dir.glob("*.trs").sort_by {|s| File.basename(s, ".trs").to_i }
end
count = 1

for file in files
  base = File.dirname(file) + "/" + File.basename(file, ".trs")
  subdir = (File.dirname(file) == ".") ? 
    dir : (dir + "/" + File.dirname(file))
  system "mkdir -p #{subdir}" unless FileTest.exist? subdir
  status_file = "#{dir}/#{base}.status"
  txt_file = "#{dir}/#{base}.txt"
  timeout_flag = false
  if skip status_file, timeout
    puts "#{count}/#{files.size}:  #{base}.status exists.  skipped"
  else 
    time0 = Time.now
    if FileTest.exists?(command) && ! FileTest.directory?(command)
      cmd = "./#{command} #{file} #{timeout.to_i}"
    else
      cmd = "#{command} #{file} #{timeout.to_i}"
    end
    puts "#{count}/#{files.size}:  #{cmd}"
    txt = `#{cmd}`
    time = Time.now - time0
    open(txt_file, "w+") {|f| f << txt }
    status = (txt =~ /(YES|NO|MAYBE|TIMEOUT)/) ? $1 : 
             (time >= timeout.to_i ? "TIMEOUT" : "ERROR")
    open(status_file, "w+") {|f| 
      f.puts "timeout = #{timeout};"
      f.puts "time = #{format("%.03f", (status == "TIMEOUT" ? timeout : time))};"
      f.puts "status = #{status};"
    }
  end
  count += 1
end
