(* $Id: term.mli,v 1.8 2005/07/13 11:46:23 nao Exp $ *)

(** Term operations *)

type t = 
  | V of string
  | F of string * t list

type binding = string * t

type subst = binding list

val print : Format.formatter -> t -> unit

val variables : t -> string list

val functions : t -> string list

val count_variable : string -> t -> int

val signature : t -> Signature.t

val subterms : t -> t list

val proper_subterms : t -> t list

val is_variable : t -> bool

val is_subterm : t -> t -> bool

val is_proper_subterm : t -> t -> bool

val root : t -> string

val ren : t -> t

val substitute : subst -> t -> t

val rename : t -> t

val fresh : unit -> string

val positions : t -> int list list

val variable_positions : t -> int list list

val function_positions : t -> int list list

val subterm_at : int list -> t -> t

val replace : t -> t -> int list -> t

val direct_subterms : t -> t list

val count_variables : t -> string -> int

val linear : t -> bool

val flatten : string list -> t -> t

val unflatten : string list -> t -> t
