open Format
open Term
open Rewriting

let rec var_name fs i = 
  let xs = Listset.diff ["x";"y";"z";"w"] fs in
  let n = List.length xs in
  if i < n then List.nth xs i else 
  let x = sprintf "x%d" (i - n + 1) in 
  if List.mem x fs then
    var_name fs (i + 1)
  else 
    x

let rename_rule fs (l, r) =
  let s = [ x, V (var_name fs i) | i, x <- Listx.ix (Rule.variables (l, r)) ] in
  (substitute s l, substitute s r)

let rename_rules rs =
  let fs = Rules.functions rs in
  [ rename_rule fs rule | rule <- rs ]

