package evotech;

import uchicago.src.sim.engine.*;
import uchicago.src.sim.gui.*;
import java.util.*;
import java.awt.*;

/**
 * <p>Title: EvoTech</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: </p>
 *
 * The logic of the agent.
 *
 * @author Laszlo Gulyas & George Kampis
 * @version 1.0
 */
public class Agent implements Stepable, Drawable {

/**
 * Agent parameters.
 */
ArrayList props;                              // The list of properties
int       numChildren;                        // Number of the agent's offsprings

int       age;                                // The age of the agent (for discounting).
double    energy;                             // The energy, the agent has.
double    eConsumption;                       // The energy need of the agent per step.
double    eInput;                             // The max. energy an agent can get per step.
double    eDisc;                              // The discounting factor of energy input.

int       ID;                                 // To be able to distinguish agents
                                              // in statistics...

/**
 * Technical variables.
 */
Model model;                                  // Reference to the model


  /**
   * Constructor of the agent.
   *
   * @param model Reference to the containing model.
   */
  public Agent(int ID, Model model) {
    // Copying initialization parameters.
    this.ID = ID;
    this.model = model;
    model.idCount++;

    numChildren = 0;

    age = 0;
    energy = 0;
    eConsumption = model.eConsumption;
    eInput = model.eInput;
    eDisc = model.eDisc;

    // Creating the initial property string randomly.
    props = new ArrayList();
    for (int i=0; i<model.numProps; i++) {
      // Random property in the range specified by the model.
      props.add(new Integer(model.getNextIntFromTo(model.minProp, model.maxProp)));
    }
  }

  /**
   * Reproduction.
   *
   * @param other The other parent.
   * @return Child.
   */
  public void reproduceWith(Agent anAgent, Agent other) {
    Agent[] parents = new Agent[] {this, other};
    anAgent.props = new ArrayList();
    int current = 0;

    for (int i=0; i<model.numProps; i++) {
      Integer prop = null;

      // Cross-over.
      if (model.getNextDoubleFromTo(0.0, 1.0) < model.pCrossOver) {
        current = 1 - current;
      }

      // Mutation and copying.
      if (model.getNextDoubleFromTo(0.0, 1.0) < model.pMutation) {

        // Creating a new slot with a certain probability
        // and add it to each agent. Otherwise, we do 'standard' mutation.
        if (model.getNextDoubleFromTo(0.0, 1.0) < model.pNewSlot) {
          model.addPropToAll();
          // And in this case we copy the original value
          Integer io = (Integer) parents[current].props.get(i);
          prop = new Integer(io.intValue());
        } else {
          prop = new Integer(model.getNextIntFromTo(model.minProp, model.maxProp));
        }

      } else {
        Integer io = (Integer) parents[current].props.get(i);
        prop = new Integer(io.intValue());
      }

      anAgent.props.add(prop);
    }

  }

  /**
   * Extending the agent's property string with a random property.
   */
  public void addProp() {
    props.add(new Integer(model.getNextIntFromTo(model.minProp, model.maxProp)));
  }


  /**
   * The method executed in each round.
   */
  public void step() {
    if (model.isDeath) {
      double energyIn = model.getFood(eInput);
      // Note that age has not been incremented yet, so
      // its eDisc^0 = 1 in the first step.
      energyIn = energyIn * Math.pow(eDisc, age);
      energy += energyIn;

      // And now we can increase the age
      age++;

      // And consume energy
      energy -= eConsumption;

      if (energy <0)  {
        model.removeAgent(this);
        return;
      }
    }

    // With a certain probability, the agents meets another one
    if (model.getNextDoubleFromTo(0.0, 1.0) < model.pEncounter)  {
      // Encounter: We pick an agent that is different from us.

      // Technical safeguard: check if we're alone
      int size = model.getPopulationSize();
      if (size > 1) {
        Agent other;
        do {
          other = (Agent) model.getAgent(model.getNextIntFromTo(0, size-1));
        } while ((other == this) ); //|| (model.removeList.contains(other)));

        encounterWith(other);
      }
    }
  }

////////////////////////////////////////////////////////////////////////////////


  /**
   * Implements the 'rendez-vous' between two agents.
   *
   * @param other The other agent.
   */
  public void encounterWith(Agent other) {

    double dist = compareProps(other);

//System.out.println("d="+dist);

    // Creating new agents, the number based on the distance
    // 'Fitness' function:
    int num = model.getChildNum(dist, numChildren);
//System.out.println("Dist="+dist+" num="+num);

    for (int i=0; i<num; i++) {
      Agent anAgent = new Agent(model.idCount, model);
      reproduceWith(anAgent, other);
      model.addAgent(anAgent);

//System.out.println("Distance1="+anAgent.compareProps(this)+", Distance2="+anAgent.compareProps(other));

//      if (model.getNextDoubleFromTo(0.0, 1.0) < model.pNewSlot) {
//        model.addPropToAll();
//      }

    }

    numChildren += num;
  }

  /**
   * Compares the property strings of the agent to that of the parameter.
   * @param other The other agent.
   * @return The normalized average distance between the props.
   */
  public double compareProps(Agent other) {
    double dist = 0;
    for (int i=0; i<props.size(); i++) {
      Integer own = (Integer) props.get(i);
      Integer others = (Integer) other.props.get(i);
      int ownint = own.intValue();
      int othersint = others.intValue();
      dist += (ownint - othersint) * (ownint - othersint);
    }

    // Normalizing it
    double maxDist = (model.maxProp - model.minProp) * (model.maxProp - model.minProp);
    maxDist = maxDist * model.numProps;

    return dist / maxDist;
  }

////////////////////////////////////////////////////////////////////////////////
// Methods needed to be able to display the agent on the screen.
////////////////////////////////////////////////////////////////////////////////

  public int getX() {
    return 0;
  }

  public int getY() {
    return 0;
  }

  public void draw(SimGraphics g) {
    g.drawFastCircle(Color.red);
  }

////////////////////////////////////////////////////////////////////////////////

  // Converting the agent to String (for statistics)
  public String toString() {
    return ""+ID;
  }
}