package evotech;

import javax.swing.*;
import java.awt.*;
import javax.swing.event.*;
import java.awt.event.*;

public class BallGeneratorFrame extends JFrame {
  JPanel jPanel1 = new JPanel();
  JPanel jPanel2 = new JPanel();
  JPanel jPanel3 = new JPanel();
  GridBagLayout gridBagLayout1 = new GridBagLayout();
  JButton jButton2 = new JButton();
  FlowLayout flowLayout1 = new FlowLayout();
  GridBagLayout gridBagLayout2 = new GridBagLayout();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JSlider jSlider1 = new JSlider();
  JSlider jSlider2 = new JSlider();
  JTextField jTextField2 = new JTextField();
  JTextField jTextField3 = new JTextField();
  JScrollPane jScrollPane1 = new JScrollPane();
  JPanel jPanel4 = new JPanel();
  GridBagLayout gridBagLayout3 = new GridBagLayout();
  JLabel jLabel4 = new JLabel();
  JLabel jLabel5 = new JLabel();

  JLabel jLabel3 = new JLabel();
  JSlider jSlider3 = new JSlider();

  JLabel[] propLabels;
  JSlider[] propSliders;

  ModelGUI model;

  public BallGeneratorFrame(ModelGUI model) {
    super("Generating Agents in a Ball");

    this.model = model;

    try {
      this.setSize(500, 400);
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  private void jbInit() throws Exception {
    this.getContentPane().setLayout(gridBagLayout1);
    jPanel3.setLayout(flowLayout1);
    jButton2.setToolTipText("Starts the Generation of the Agents.");
    jButton2.setText("Generate");
    jButton2.addActionListener(new BallGeneratorFrame_jButton2_actionAdapter(this));
    jPanel1.setLayout(gridBagLayout2);
    jLabel1.setText("#Agents to Generate");
    jLabel2.setRequestFocusEnabled(true);
    jLabel2.setText("Max. Distance (x1000)");
    jTextField3.setEnabled(false);
    jTextField3.setMinimumSize(new Dimension(34, 21));
    jTextField3.setPreferredSize(new Dimension(34, 21));
    jTextField3.setEditable(true);
    jTextField2.setEnabled(false);
    jTextField2.setMinimumSize(new Dimension(34, 21));
    jTextField2.setPreferredSize(new Dimension(34, 21));
    jTextField2.setEditable(true);
    jSlider2.setMaximum(1000);
    jSlider2.setValue(100);
    jSlider2.setMajorTickSpacing(500);
    jSlider2.setMinorTickSpacing(50);
    jSlider2.setPaintLabels(true);
    jSlider2.setPaintTicks(true);
    jSlider2.setDoubleBuffered(false);
    jSlider2.setToolTipText("The Number of Agents to Generate.");
    jSlider2.addChangeListener(new BallGeneratorFrame_jSlider2_changeAdapter(this));
    jSlider1.setMaximum(1000);
    jSlider1.setMinimum(1);
    jSlider1.setValue(100);
    jSlider1.setMajorTickSpacing(499);
    jSlider1.setMinorTickSpacing(50);
    jSlider1.setPaintLabels(true);
    jSlider1.setPaintTicks(true);
    jSlider1.setDebugGraphicsOptions(0);
    jSlider1.setToolTipText("The maximum allowed distance from the ball\'s center (multiplied by " +
    "100).");
    jSlider1.addChangeListener(new BallGeneratorFrame_jSlider1_changeAdapter(this));
    jPanel2.setLayout(null);
    jScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
    jScrollPane1.getViewport().setBackground(Color.lightGray);
    jScrollPane1.setOpaque(true);
    jScrollPane1.setPreferredSize(new Dimension(200, 200));
    jScrollPane1.setBounds(new Rectangle(-1, 0, 464, 193));
    jPanel2.setBackground(SystemColor.activeCaptionBorder);
    jPanel1.setPreferredSize(new Dimension(394, 79));

    jTextField3.setText(this.jSlider2.getValue()+"");
    jTextField2.setText(this.jSlider1.getValue()+"");

    this.setResizable(false);
    jPanel4.setBackground(Color.lightGray);
    jPanel4.setAlignmentY((float) 0.5);
    jPanel4.setLayout(gridBagLayout3);

    jLabel4.setBackground(Color.gray);
    jLabel4.setFont(new java.awt.Font("Dialog", 3, 11));
    jLabel4.setForeground(Color.black);
    jLabel4.setDebugGraphicsOptions(0);
    jLabel4.setOpaque(true);
    jLabel4.setHorizontalAlignment(SwingConstants.CENTER);
    jLabel4.setHorizontalTextPosition(SwingConstants.TRAILING);
    jLabel4.setText("Property");
    jLabel5.setBackground(Color.darkGray);
    jLabel5.setForeground(Color.white);
    jLabel5.setFont(new java.awt.Font("Dialog", 3, 11));
    jLabel5.setOpaque(true);
    jLabel5.setHorizontalAlignment(SwingConstants.CENTER);
    jLabel5.setText("Center\'s Value");

/*
    jLabel3.setBackground(SystemColor.activeCaptionBorder);
    jLabel3.setOpaque(true);
    jLabel3.setHorizontalAlignment(SwingConstants.TRAILING);
    jLabel3.setHorizontalTextPosition(SwingConstants.TRAILING);
    jLabel3.setText("#1  ");

    jSlider3.setMajorTickSpacing(5);
    jSlider3.setMaximum(10);
    jSlider3.setMinorTickSpacing(1);
    jSlider3.setPaintLabels(true);
    jSlider3.setPaintTicks(true);
    jSlider3.setPaintTrack(true);
*/

    int num = model.numProps;
    propLabels = new JLabel[num];
    propSliders = new JSlider[num];
    for (int i=0; i<num; i++) {
      propLabels[i] = new JLabel();
      propLabels[i].setBackground(SystemColor.activeCaptionBorder);
      propLabels[i].setOpaque(true);
      propLabels[i].setHorizontalAlignment(SwingConstants.TRAILING);
      propLabels[i].setHorizontalTextPosition(SwingConstants.TRAILING);
      propLabels[i].setVerticalAlignment(SwingConstants.TOP);
      propLabels[i].setText("#"+i+"  ");

      propSliders[i] = new JSlider();
      propSliders[i].setMajorTickSpacing(model.maxProp / 2);
      propSliders[i].setMinimum(model.minProp);
      propSliders[i].setMaximum(model.maxProp);
      propSliders[i].setMinorTickSpacing(1);
      propSliders[i].setPaintLabels(true);
      propSliders[i].setPaintTicks(true);
      propSliders[i].setPaintTrack(true);
      propSliders[i].setValue(model.maxProp / 2);
      propSliders[i].setSnapToTicks(true);
    }

    // Putting the components together
    this.getContentPane().add(jPanel1,                            new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 455, 0));
    this.getContentPane().add(jPanel2,                                        new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 2, 0), 455, 155));
    jPanel2.add(jScrollPane1, null);
    this.getContentPane().add(jPanel3,                               new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0
            ,GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(2, 0, 0, 0), 455, 0));
    jPanel3.add(jButton2, null);
    jPanel1.add(jLabel1,                 new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanel1.add(jLabel2,              new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanel1.add(jTextField2,          new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanel1.add(jTextField3,        new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanel1.add(jSlider2,     new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));
    jPanel1.add(jSlider1,  new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0
            ,GridBagConstraints.SOUTHEAST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
    jPanel4.add(jLabel4,   new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    jPanel4.add(jLabel5,   new GridBagConstraints(9, 0, 10, 1, 0.0, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

/*
    jPanel4.add(jLabel3,                new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0
            ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 5, 37));
    jPanel4.add(jSlider3,                                new GridBagConstraints(1, 1, 9, 2, 10.0, 1.0
            ,GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 5, 5));
*/

    for (int i=0; i<num; i++) {
      jPanel4.add(propLabels[i],
        new GridBagConstraints( 0, 2+i, 1, 1, 1.0, 1.0,
          GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL,
          new Insets(0, 0, 0, 0), 5, 37
        )
      );
      jPanel4.add(propSliders[i],
        new GridBagConstraints( 1, 2+i, 9, 2, 10.0, 1.0,
          GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL,
          new Insets(0, 0, 0, 0), 5, 5
        )
      );
    }
    jScrollPane1.getViewport().add(jPanel4, null);

  }

  void jSlider2_stateChanged(ChangeEvent e) {
    this.jTextField3.setText(jSlider2.getValue()+"");
  }

  void jSlider1_stateChanged(ChangeEvent e) {
    this.jTextField2.setText(jSlider1.getValue()+"");
  }

  void jButton2_actionPerformed(ActionEvent e) {
    int[] props = new int[model.numProps];
    for (int i=0; i<model.numProps; i++) {
      props[i] = propSliders[i].getValue();
    }
    model.generateAgentsInABall( jSlider2.getValue(),
                                 (double) jSlider1.getValue() / 1000.0,
                                 props );
    this.dispose();
  }

}

class BallGeneratorFrame_jSlider2_changeAdapter implements javax.swing.event.ChangeListener {
  BallGeneratorFrame adaptee;

  BallGeneratorFrame_jSlider2_changeAdapter(BallGeneratorFrame adaptee) {
    this.adaptee = adaptee;
  }
  public void stateChanged(ChangeEvent e) {
    adaptee.jSlider2_stateChanged(e);
  }

  public static void main(String[] args) {
    BallGeneratorFrame f = new BallGeneratorFrame(new ModelGUI());
    f.show();
  }
}

class BallGeneratorFrame_jSlider1_changeAdapter implements javax.swing.event.ChangeListener {
  BallGeneratorFrame adaptee;

  BallGeneratorFrame_jSlider1_changeAdapter(BallGeneratorFrame adaptee) {
    this.adaptee = adaptee;
  }
  public void stateChanged(ChangeEvent e) {
    adaptee.jSlider1_stateChanged(e);
  }
}

class BallGeneratorFrame_jButton2_actionAdapter implements java.awt.event.ActionListener {
  BallGeneratorFrame adaptee;

  BallGeneratorFrame_jButton2_actionAdapter(BallGeneratorFrame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton2_actionPerformed(e);
  }
}