package evotech;

import uchicago.src.sim.engine.*;
import java.util.*;

/**
 * <p>Title: EvoTech</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: </p>
 *
 * The global logic of the model.
 *
 * @author Laszlo Gulyas & George Kampis
 * @version 1.0
 */
public class Model extends SimpleModel {

/**
 * Model parameters.
 */
double pEncounter;                // The probability of encounter.
double pCrossOver;                // The probability of cross-over.
double pMutation;                 // The probability of mutation.
double pNewSlot;                  // The probability of a new slot (upon encounter).

// Parameteres for the distance->numChildren mapping
double mappingLimit;              // Limit within (0.0, 1.0) above which numCh=0.
int    mappingMax;                // Max. num of children at 0.0 distance.

int numProps;                     // The length of property string.
int minProp;                      // The lower boundary on the property range.
int maxProp;                      // The lower boundary on the property range.
int numAgents;                    // The initial number of agents.
int numOffsprings;                // The number of offsprings created.

// Survival-related parameters
boolean isDeath;
double  eConsumption;
double  eInput;
double  eDisc;

// Environmental energy
int    initEnergy;                  // Initial energy in the world.
int    incrEnergy;                  // New amount of energy per step.

/**
 * Model variables.
 */
ArrayList removeList;
int idCount;
double energy;                      // Available energy in the world.


  /**
   * Initializing the model (setting default values, etc.)
   * Setting RePast up, etc.
   */
  public void setup() {
    super.setup();                // Making sure the parent class' job is done.

    numAgents = 100;

    minProp = 0;
    maxProp = 10; //100;
    numProps = 5;

    pEncounter = 0.5; //1.0; //0.01; // 1.0;
    pCrossOver = 0.5; //0; //0.5;
    pMutation = 0.2; //0; //0.1; //0; //0.1;
    pNewSlot = 0; //0.01; //0; //0.01;

    mappingLimit = 0.02; //0.01; //0.02; //0.2;
    mappingMax = 4; //3; //30; //5;


    isDeath = true;
    eConsumption = 5;
    eInput = 10;
    eDisc = 0.9;

    initEnergy = 1000;
    incrEnergy = 1000; //1;

    // Causes RePast to call each agent's (in the agentList)
    // step() method in each time step.
    autoStep = true;

    // Causes to randomize the order in which the agents' step() method
    // is called.
    shuffle = true;
  }

  /**
   * Creating the initial model structures.
   */
  public void buildModel() {
    super.buildModel();           // Making sure the parent class' job is done.

    // Creating the agents.
    idCount = 0;
    for (int i=0; i<numAgents; i++) {
      addAgent(new Agent(idCount, this));
    }

    removeList = new ArrayList();

    energy = initEnergy;
  }

  public void postStep() {

    energy += incrEnergy;

    if (removeList.size() > 0) {
      agentList.removeAll(removeList);

      removeList.clear();
    }
  }

////////////////////////////////////////////////////////////////////////////////
// Helper methods
////////////////////////////////////////////////////////////////////////////////

  public double getFood(double wanted) {
    if (energy > wanted) {
      energy -= wanted;
    } else {
      wanted = energy;
      energy = 0;
    }
    return wanted;
  }

  public int getChildNum(double dist, int numChildren) {
    if (dist > mappingLimit)
      return 0;

    return (int) (mappingMax - dist * (mappingMax / mappingLimit));
  }

  /**
   * Adds a new property (with a random value) to the property string of all
   * agents.
   */
  public void addPropToAll() {
    numProps++;
    Iterator i = agentList.iterator();
    while (i.hasNext()) {
      Agent a = (Agent) i.next();
      a.addProp();
    }
  }

  /**
   * Method to add a new agent.
   * Technically, this is only needed due to a mis-implementation in the
   * current version of RePast.
   * @param anAgent The agent to be added.
   */
  public void addAgent(Agent anAgent) {
    agentList.add(anAgent);
  }

  public void removeAgent(Agent anAgent) {
    removeList.add(anAgent);
  }

  public int getPopulationSize() {
    return agentList.size();
  }

  public Agent getAgent(int i) {
    return (Agent) agentList.get(i);
  }
}